/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.javascript.JSObject;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAppletInterface;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.applet.JmolAppletRegistry;
import org.jmol.applet.Jvm12;
import org.jmol.appletwrapper.AppletWrapper;
import org.jmol.appletwrapper.WrappedApplet;
import org.jmol.i18n.GT;
import org.jmol.popup.JmolPopup;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public class Jmol
implements WrappedApplet,
JmolAppletInterface {
    JmolViewer viewer;
    boolean jvm12orGreater;
    String emulate;
    Jvm12 jvm12;
    JmolPopup jmolpopup;
    String htmlName;
    public JmolAppletRegistry appletRegistry;
    MyStatusListener myStatusListener;
    AppletWrapper appletWrapper;
    JSObject jsoWindow;
    JSObject jsoDocument;
    boolean mayScript;
    String animFrameCallback;
    String loadStructCallback;
    String messageCallback;
    String pickCallback;
    String statusForm;
    String statusText;
    String statusTextarea;
    static final boolean REQUIRE_PROGRESSBAR = true;
    boolean hasProgressBar;
    int paintCounter;
    static final String[] progressbarMsgs = new String[]{"Jmol developer alert!", "", "progressbar is REQUIRED ... otherwise users", "will have no indicate that the applet is loading", "", "<applet code='JmolApplet' ... >", "  <param name='progressbar' value='true' />", "  <param name='progresscolor' value='blue' />", "  <param name='boxmessage' value='your-favorite-message' />", "  <param name='boxbgcolor' value='#112233' />", "  <param name='boxfgcolor' value='#778899' />", "   ...", "</applet>"};
    public boolean showPaintTime = false;
    static int timeLast = 0;
    static int timeCount;
    static int timeTotal;
    long timeBegin;
    int lastMotionEventNumber;
    final Object[] buttonCallbackBefore = new Object[]{null, Boolean.FALSE};
    final Object[] buttonCallbackAfter = new Object[]{null, Boolean.TRUE};
    boolean buttonCallbackNotificationPending;
    String buttonCallback;
    String buttonName;
    JSObject buttonWindow;

    public void setAppletWrapper(AppletWrapper appletWrapper) {
        this.appletWrapper = appletWrapper;
    }

    public void init() {
        this.htmlName = this.getParameter("name");
        System.out.println("Jmol applet " + this.htmlName);
        this.setLogging();
        String ms = this.getParameter("mayscript");
        this.mayScript = ms != null && !ms.equalsIgnoreCase("false");
        this.appletRegistry = new JmolAppletRegistry(this.htmlName, this.mayScript, this.appletWrapper);
        this.initWindows();
        this.initApplication();
    }

    String getParameter(String paramName) {
        return this.appletWrapper.getParameter(paramName);
    }

    public void initWindows() {
        this.viewer = JmolViewer.allocateViewer(this.appletWrapper, new SmarterJmolAdapter(null));
        this.myStatusListener = new MyStatusListener();
        this.viewer.setJmolStatusListener(this.myStatusListener);
        this.viewer.setAppletContext(this.htmlName, this.appletWrapper.getDocumentBase(), this.appletWrapper.getCodeBase(), this.getValue("JmolAppletProxy", null));
        this.jvm12orGreater = this.viewer.isJvm12orGreater();
        if (this.jvm12orGreater) {
            this.jvm12 = new Jvm12(this.appletWrapper, this.viewer);
        }
        if (this.mayScript) {
            try {
                this.jsoWindow = JSObject.getWindow((Applet)this.appletWrapper);
                if (this.jsoWindow == null) {
                    Logger.error("jsoWindow returned null ... no JavaScript callbacks :-(");
                }
                this.jsoDocument = (JSObject)this.jsoWindow.getMember("document");
                if (this.jsoDocument == null) {
                    Logger.error("jsoDocument returned null ... no DOM manipulations :-(");
                }
            }
            catch (Exception e) {
                Logger.error("" + e);
            }
        }
    }

    void setLogging() {
        String logLevel = this.getValue("logLevel", "") + "4";
        for (int i = 0; i < 5; ++i) {
            Logger.setActiveLevel(i, false);
        }
        if (logLevel.charAt(0) > '5') {
            logLevel = "5";
        }
        if (logLevel.charAt(0) != '4') {
            System.out.println("setting logLevel=" + logLevel.charAt(0) + " -- To change, use script \"set logLevel [0-5]\"");
        }
        switch (logLevel.charAt(0)) {
            case '5': {
                Logger.setActiveLevel(0, true);
            }
            case '4': {
                Logger.setActiveLevel(1, true);
            }
            case '3': {
                Logger.setActiveLevel(2, true);
            }
            case '2': {
                Logger.setActiveLevel(3, true);
            }
            case '1': {
                Logger.setActiveLevel(4, true);
            }
        }
    }

    boolean getBooleanValue(String propertyName, boolean defaultValue) {
        String value = this.getValue(propertyName, defaultValue ? "true" : "");
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes");
    }

    String getValue(String propertyName, String defaultValue) {
        String stringValue = this.getParameter(propertyName);
        if (stringValue != null) {
            return stringValue;
        }
        return defaultValue;
    }

    String getValueLowerCase(String paramName, String defaultValue) {
        String value = this.getValue(paramName, defaultValue);
        if (value != null && (value = value.trim().toLowerCase()).length() == 0) {
            value = null;
        }
        return value;
    }

    public void initApplication() {
        this.viewer.pushHoldRepaint();
        this.hasProgressBar = this.getBooleanValue("progressbar", false);
        boolean popupMenu = this.getBooleanValue("popupMenu", true);
        if (popupMenu) {
            this.loadPopupMenuAsBackgroundTask();
        }
        this.emulate = this.getValueLowerCase("emulate", "jmol");
        if (this.emulate.equals("chime")) {
            this.viewer.setRasmolDefaults();
        } else {
            this.viewer.setJmolDefaults();
        }
        String bgcolor = this.getValue("boxbgcolor", "black");
        bgcolor = this.getValue("bgcolor", bgcolor);
        this.viewer.setColorBackground(bgcolor);
        this.loadNodeId(this.getValue("loadNodeId", null));
        this.viewer.setFrankOn(true);
        this.animFrameCallback = this.getValue("AnimFrameCallback", null);
        this.loadStructCallback = this.getValue("LoadStructCallback", null);
        this.messageCallback = this.getValue("MessageCallback", null);
        this.pickCallback = this.getValue("PickCallback", null);
        this.statusForm = this.getValue("StatusForm", null);
        this.statusText = this.getValue("StatusText", null);
        this.statusTextarea = this.getValue("StatusTextarea", null);
        if (this.animFrameCallback != null) {
            Logger.info("animFrameCallback=" + this.animFrameCallback);
        }
        if (this.loadStructCallback != null) {
            Logger.info("loadStructCallback=" + this.loadStructCallback);
        }
        if (this.messageCallback != null) {
            Logger.info("messageCallback=" + this.messageCallback);
        }
        if (this.pickCallback != null) {
            Logger.info("pickCallback=" + this.pickCallback);
        }
        if (this.statusForm != null && this.statusText != null) {
            Logger.info("applet text status will be reported to document." + this.statusForm + "." + this.statusText);
        }
        if (this.statusForm != null && this.statusTextarea != null) {
            Logger.info("applet textarea status will be reported to document." + this.statusForm + "." + this.statusTextarea);
        }
        if (!(this.mayScript || this.animFrameCallback == null && this.loadStructCallback == null && this.messageCallback == null && this.pickCallback == null)) {
            Logger.warn("WARNING!! MAYSCRIPT not found");
        }
        String scriptParam = this.getValue("script", "");
        String loadParam = this.getValue("load", null);
        if (loadParam != null) {
            scriptParam = "load " + loadParam + ";" + scriptParam;
        } else {
            this.loadInline(this.getValue("loadInline", null));
        }
        this.script(scriptParam);
        this.viewer.popHoldRepaint();
    }

    void showStatusAndConsole(String message) {
        this.appletWrapper.showStatus(message);
        this.sendJsTextStatus(message);
        this.consoleMessage(message);
    }

    void sendMessageCallback(String strMsg) {
        if (this.messageCallback != null && this.jsoWindow != null) {
            this.jsoWindow.call(this.messageCallback, this.htmlName, strMsg);
        }
    }

    void sendJsTextStatus(String message) {
        if (this.statusForm == null || this.statusText == null) {
            return;
        }
        try {
            JSObject jsoForm = (JSObject)this.jsoDocument.getMember(this.statusForm);
            if (this.statusText != null) {
                JSObject jsoText = (JSObject)jsoForm.getMember(this.statusText);
                jsoText.setMember("value", message);
            }
        }
        catch (Exception e) {
            Logger.error("error indicating status at document." + this.statusForm + "." + this.statusText + ":" + e.toString());
        }
    }

    void sendJsTextareaStatus(String message) {
        if (this.statusForm == null || this.statusTextarea == null) {
            return;
        }
        try {
            JSObject jsoForm = (JSObject)this.jsoDocument.getMember(this.statusForm);
            if (this.statusTextarea != null) {
                JSObject jsoTextarea = (JSObject)jsoForm.getMember(this.statusTextarea);
                String info = (String)jsoTextarea.getMember("value");
                jsoTextarea.setMember("value", info + "\n" + message);
            }
        }
        catch (Exception e) {
            Logger.error("error indicating status at document." + this.statusForm + "." + this.statusTextarea + ":" + e.toString());
        }
    }

    void consoleMessage(String message) {
        if (this.jvm12 != null) {
            this.jvm12.consoleMessage(message);
        }
        this.sendJsTextareaStatus(message);
    }

    public void update(Graphics g) {
        if (this.viewer == null) {
            return;
        }
        if (this.showPaintTime) {
            this.startPaintClock();
        }
        Dimension size = this.jvm12orGreater ? this.jvm12.getSize() : this.appletWrapper.size();
        this.viewer.setScreenDimension(size);
        Rectangle rectClip = this.jvm12orGreater ? this.jvm12.getClipBounds(g) : g.getClipRect();
        ++this.paintCounter;
        if (!this.hasProgressBar && this.paintCounter < 30 && (this.paintCounter & 1) == 0) {
            this.printProgressbarMessage(g);
            this.viewer.repaintView();
        } else {
            this.viewer.renderScreenImage(g, size, rectClip);
        }
        if (this.showPaintTime) {
            this.stopPaintClock();
            this.showTimes(10, 10, g);
        }
    }

    void printProgressbarMessage(Graphics g) {
        g.setColor(Color.yellow);
        g.fillRect(0, 0, 10000, 10000);
        g.setColor(Color.black);
        int i = 0;
        int y = 13;
        while (i < progressbarMsgs.length) {
            g.drawString(progressbarMsgs[i], 10, y);
            ++i;
            y += 13;
        }
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public boolean handleEvent(Event e) {
        if (this.viewer == null) {
            return false;
        }
        return this.viewer.handleOldJvm10Event(e);
    }

    void resetTimes() {
        timeTotal = 0;
        timeCount = 0;
        timeLast = -1;
    }

    void recordTime(int time) {
        if (timeLast != -1) {
            timeTotal += timeLast;
            ++timeCount;
        }
        timeLast = time;
    }

    void startPaintClock() {
        this.timeBegin = System.currentTimeMillis();
        int motionEventNumber = this.viewer.getMotionEventNumber();
        if (this.lastMotionEventNumber != motionEventNumber) {
            this.lastMotionEventNumber = motionEventNumber;
            this.resetTimes();
        }
    }

    void stopPaintClock() {
        int time = (int)(System.currentTimeMillis() - this.timeBegin);
        this.recordTime(time);
    }

    String fmt(int num) {
        if (num < 0) {
            return "---";
        }
        if (num < 10) {
            return "  " + num;
        }
        if (num < 100) {
            return " " + num;
        }
        return "" + num;
    }

    void showTimes(int x, int y, Graphics g) {
        int timeAverage = timeCount == 0 ? -1 : (timeTotal + timeCount / 2) / timeCount;
        g.setColor(Color.green);
        g.drawString(this.fmt(timeLast) + "ms : " + this.fmt(timeAverage) + "ms", x, y);
    }

    public void scriptButton(JSObject buttonWindow, String buttonName, String script, String buttonCallback) {
        Logger.info(this.htmlName + " JmolApplet.scriptButton(" + buttonWindow + "," + buttonName + "," + script + "," + buttonCallback);
        if (buttonWindow != null && buttonCallback != null) {
            Logger.debug("!!!! calling back " + buttonCallback);
            this.buttonCallbackBefore[0] = buttonName;
            Logger.debug("trying...");
            buttonWindow.call(buttonCallback, this.buttonCallbackBefore);
            Logger.debug("made it");
            this.buttonCallbackNotificationPending = true;
            this.buttonCallback = buttonCallback;
            this.buttonWindow = buttonWindow;
            this.buttonName = buttonName;
        } else {
            this.buttonCallbackNotificationPending = false;
        }
        this.script(script);
    }

    public synchronized void script(String script) {
        this.viewer.script(script);
    }

    public synchronized void syncScript(String script) {
        if (script.equalsIgnoreCase("on")) {
            this.myStatusListener.sendSyncScript("SLAVE", null);
            this.viewer.setSyncDriver(1);
            return;
        }
        if (script.equalsIgnoreCase("off")) {
            this.viewer.setSyncDriver(0);
            return;
        }
        if (script.equalsIgnoreCase("slave")) {
            this.viewer.setSyncDriver(-1);
            return;
        }
        if (script.equalsIgnoreCase("sync")) {
            this.viewer.setSyncDriver(2);
            return;
        }
        if (this.viewer.getSyncMode() != 0) {
            return;
        }
        Logger.debug(this.htmlName + " syncing with script: " + script);
        this.script(script);
    }

    public synchronized String scriptCheck(String script) {
        return this.viewer.scriptCheck(script);
    }

    public synchronized String scriptNoWait(String script) {
        return this.viewer.script(script);
    }

    public synchronized String scriptWait(String script) {
        return this.viewer.scriptWait(script);
    }

    public synchronized String scriptWait(String script, String statusParams) {
        this.viewer.getProperty(null, "jmolStatus", statusParams);
        return this.viewer.scriptWait(script);
    }

    public String getAppletInfo() {
        return GT._("Jmol Applet version {0} {1}.\n\nAn OpenScience project.\n\nSee http://www.jmol.org for more information", new Object[]{"10.x.28 (branch bob200603/11.0 beta)", JmolConstants.date});
    }

    public synchronized Object getProperty(String infoType) {
        return this.viewer.getProperty(null, infoType, "");
    }

    public synchronized Object getProperty(String infoType, String paramInfo) {
        return this.viewer.getProperty(null, infoType, paramInfo);
    }

    public synchronized String getPropertyAsString(String infoType) {
        return this.viewer.getProperty("String", infoType, "").toString();
    }

    public synchronized String getPropertyAsString(String infoType, String paramInfo) {
        return this.viewer.getProperty("String", infoType, paramInfo).toString();
    }

    public synchronized String getPropertyAsJSON(String infoType) {
        return this.viewer.getProperty("JSON", infoType, "").toString();
    }

    public synchronized String getPropertyAsJSON(String infoType, String paramInfo) {
        return this.viewer.getProperty("JSON", infoType, paramInfo).toString();
    }

    public void loadInline(String strModel) {
        if (strModel == null) {
            return;
        }
        this.viewer.loadInline(strModel);
    }

    public void loadInline(String strModel, String script) {
        this.loadInline(strModel);
        this.script(script);
    }

    public void loadInline(String[] arrayModel, String script) {
    }

    public void loadDOMNode(JSObject DOMNode) {
        this.viewer.openDOM(DOMNode);
    }

    public void loadNodeId(String nodeId) {
        if (nodeId != null) {
            Object[] searchArgs;
            JSObject tryNodeList;
            Object[] idArgs = new Object[]{nodeId};
            JSObject tryNode = (JSObject)this.jsoDocument.call("getElementById", idArgs);
            if (tryNode == null && (tryNodeList = (JSObject)this.jsoDocument.call("getElementsByTagNameNS", searchArgs = new Object[]{"http://www.xml-cml.org/schema/cml2/core", "cml"})) != null) {
                Object[] idArg;
                String idValue;
                for (int i = 0; i < ((Number)tryNodeList.getMember("length")).intValue() && !nodeId.equals(idValue = (String)(tryNode = (JSObject)tryNodeList.getSlot(i)).call("getAttribute", idArg = new Object[]{"id"})); ++i) {
                }
            }
            if (tryNode != null) {
                this.loadDOMNode(tryNode);
            }
        }
    }

    void loadPopupMenuAsBackgroundTask() {
        if (this.viewer.getOperatingSystemName().equals("Mac OS") && this.viewer.getJavaVersion().equals("1.1.5")) {
            return;
        }
        new Thread(new LoadPopupThread()).start();
    }

    class MyStatusListener
    implements JmolStatusListener {
        MyStatusListener() {
        }

        public void notifyFileLoaded(String fullPathName, String fileName, String modelName, Object clientFile, String errorMsg) {
            if (errorMsg != null) {
                Jmol.this.showStatusAndConsole(GT._("File Error:") + errorMsg);
                return;
            }
            if (fullPathName != null && Jmol.this.loadStructCallback != null && Jmol.this.jsoWindow != null) {
                Jmol.this.jsoWindow.call(Jmol.this.loadStructCallback, Jmol.this.htmlName, fullPathName);
            }
            if (Jmol.this.jmolpopup != null) {
                Jmol.this.jmolpopup.updateComputedMenus();
            }
        }

        public void notifyScriptStart(String statusMessage, String additionalInfo) {
            if (Jmol.this.messageCallback != null && Jmol.this.jsoWindow != null) {
                Jmol.this.jsoWindow.call(Jmol.this.messageCallback, Jmol.this.htmlName, statusMessage, additionalInfo);
            }
            Jmol.this.showStatusAndConsole(statusMessage);
        }

        public float functionXY(String functionName, int x, int y) {
            return ((Double)Jmol.this.jsoWindow.call(functionName, Jmol.this.htmlName, new Integer(x), new Integer(y))).floatValue();
        }

        public void notifyNewPickingModeMeasurement(int iatom, String strMeasure) {
            this.sendConsoleMessage(strMeasure);
        }

        public void notifyNewDefaultModeMeasurement(int count, String strInfo) {
            Jmol.this.showStatusAndConsole(strInfo);
        }

        public void notifyFrameChanged(int frameNo) {
            if (Jmol.this.animFrameCallback != null && Jmol.this.jsoWindow != null) {
                Jmol.this.jsoWindow.call(Jmol.this.animFrameCallback, Jmol.this.htmlName, new Integer(frameNo));
            }
        }

        public void notifyAtomPicked(int atomIndex, String strInfo) {
            Jmol.this.showStatusAndConsole(strInfo);
            if (Jmol.this.pickCallback != null && Jmol.this.jsoWindow != null) {
                Jmol.this.jsoWindow.call(Jmol.this.pickCallback, Jmol.this.htmlName, strInfo, new Integer(atomIndex));
            }
        }

        public void notifyScriptTermination(String errorMessage, int msWalltime) {
            Jmol.this.showStatusAndConsole(GT._(errorMessage));
            if (Jmol.this.buttonCallbackNotificationPending) {
                Logger.debug("!!!! calling back " + Jmol.this.buttonCallback);
                Jmol.this.buttonCallbackAfter[0] = Jmol.this.buttonName;
                Jmol.this.buttonWindow.call(Jmol.this.buttonCallback, Jmol.this.buttonCallbackAfter);
            }
        }

        public void sendConsoleEcho(String strEcho) {
            this.sendConsoleMessage(strEcho);
        }

        public void sendConsoleMessage(String strMsg) {
            Jmol.this.sendMessageCallback(strMsg);
            Jmol.this.consoleMessage(strMsg);
        }

        public void handlePopupMenu(int x, int y) {
            if (Jmol.this.jmolpopup != null) {
                Jmol.this.jmolpopup.show(x, y);
            }
        }

        public void showUrl(String urlString) {
            Logger.debug("showUrl(" + urlString + ")");
            if (urlString != null && urlString.length() > 0) {
                try {
                    URL url = new URL(urlString);
                    Jmol.this.appletWrapper.getAppletContext().showDocument(url, "_blank");
                }
                catch (MalformedURLException mue) {
                    Jmol.this.showStatusAndConsole("Malformed URL:" + urlString);
                }
            }
        }

        public void showConsole(boolean showConsole) {
            Logger.info("JmolApplet.showConsole(" + showConsole + ")");
            if (Jmol.this.jvm12 != null) {
                Jmol.this.jvm12.showConsole(showConsole);
            }
        }

        public void sendSyncScript(String script, String appletName) {
            Hashtable h = JmolAppletRegistry.htRegistry;
            Enumeration keys = h.keys();
            while (keys.hasMoreElements()) {
                String theApplet = (String)keys.nextElement();
                if (theApplet.equals(Jmol.this.htmlName) || appletName != null && appletName != theApplet) continue;
                Logger.debug("sendSyncScript class " + h.get(theApplet).getClass().getName());
                JmolAppletInterface app = (JmolAppletInterface)h.get(theApplet);
                try {
                    Logger.debug(Jmol.this.htmlName + " sending " + script + " to " + theApplet);
                    app.syncScript(script);
                }
                catch (Exception e) {
                    Logger.debug(Jmol.this.htmlName + " couldn't send " + script + " to " + theApplet + ": " + e);
                }
            }
        }
    }

    class LoadPopupThread
    implements Runnable {
        LoadPopupThread() {
        }

        public void run() {
            JmolPopup popup;
            Thread.currentThread().setPriority(1);
            try {
                popup = JmolPopup.newJmolPopup(Jmol.this.viewer);
            }
            catch (Exception e) {
                Logger.error("JmolPopup not loaded");
                return;
            }
            if (Jmol.this.viewer.haveFrame()) {
                popup.updateComputedMenus();
            }
            Jmol.this.jmolpopup = popup;
        }
    }
}

