/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point4f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;

class Symmetry {
    String xyzOriginal;
    String xyz;
    Matrix4f operation;
    int[] ptLatt = new int[4];
    static final int[] latticeTranslations6ths = new int[]{8, 3, 3, 3, 17, 1, 2, 2, 18, 2, 1, 1, 33, 0, 3, 3, 34, 3, 0, 3, 35, 3, 3, 0, 64, 0, 3, 3, 128, 3, 0, 3, 256, 3, 3, 0};
    static final int[] ptNoLatt = new int[]{0, 0, 0, 1};
    static final String[] latticeDesignations = new String[]{"", "primitive", "rhombohedral", "body-centered", "face-centered", "A-centered", "B-centered", "C-centered"};
    final Atom atomTest = new Atom();

    Symmetry() {
    }

    static final int getLatticeOperations(int latt, int[][] pt) {
        int ipt = 0;
        if (latt > 0) {
            pt[0] = new int[4];
            pt[0][3] = -1;
            ipt = 1;
        } else {
            latt = -latt;
        }
        if (latt < 2) {
            return ipt;
        }
        for (int i = 0; i < 9; ++i) {
            int lpt = i * 4;
            if ((latticeTranslations6ths[lpt++] & 2 << latt) == 0) continue;
            pt[ipt] = new int[4];
            pt[ipt][0] = latticeTranslations6ths[lpt++];
            pt[ipt][1] = latticeTranslations6ths[lpt++];
            pt[ipt][2] = latticeTranslations6ths[lpt++];
            ++ipt;
        }
        return ipt;
    }

    static final String getLatticeDesignation(int latt) {
        boolean isCentrosymmetric;
        boolean bl = isCentrosymmetric = latt > 0;
        if (latt < 0) {
            latt = -latt;
        }
        return (isCentrosymmetric ? "centrosymmetric " : "") + latticeDesignations[latt] + " (" + latt + ")";
    }

    boolean setMatrixFromXYZ(String xyz) {
        return this.setMatrixFromXYZandLatt(xyz, ptNoLatt);
    }

    boolean setMatrixFromXYZandLatt(String xyz, int[] ptLatt) {
        boolean isInverted;
        this.xyzOriginal = xyz;
        this.ptLatt[0] = ptLatt[0];
        this.ptLatt[1] = ptLatt[1];
        this.ptLatt[2] = ptLatt[2];
        this.ptLatt[3] = ptLatt[3];
        this.operation = new Matrix4f();
        float[] temp = new float[16];
        boolean isDenominator = false;
        boolean isDecimal = false;
        boolean isNegative = isInverted = ptLatt[3] == -1;
        int x = 0;
        int y = 0;
        int z = 0;
        float iValue = 0.0f;
        String strOut = "";
        int rowPt = -1;
        float decimalMultiplier = 1.0f;
        xyz = xyz + ",";
        block12: for (int i = 0; i < xyz.length(); ++i) {
            char ch = xyz.charAt(i);
            switch (ch) {
                case ' ': 
                case '\'': {
                    continue block12;
                }
                case '-': {
                    isNegative = !isInverted;
                    continue block12;
                }
                case '+': {
                    isNegative = isInverted;
                    continue block12;
                }
                case '/': {
                    isDenominator = true;
                    continue block12;
                }
                case 'X': 
                case 'x': {
                    x = isNegative ? -1 : 1;
                    break;
                }
                case 'Y': 
                case 'y': {
                    y = isNegative ? -1 : 1;
                    break;
                }
                case 'Z': 
                case 'z': {
                    z = isNegative ? -1 : 1;
                    break;
                }
                case ',': {
                    if (++rowPt > 2) {
                        Logger.warn("Symmetry Operation? " + xyz);
                        return false;
                    }
                    int tpt = rowPt * 4;
                    if ((double)(iValue += (float)ptLatt[rowPt] / 6.0f) > 0.5) {
                        iValue -= 1.0f;
                    }
                    if ((double)iValue < -0.5) {
                        iValue += 1.0f;
                    }
                    temp[tpt++] = x;
                    temp[tpt++] = y;
                    temp[tpt++] = z;
                    temp[tpt] = iValue;
                    String strT = "";
                    strT = strT + (x == 0 ? "" : (x < 0 ? "-x" : (strT.length() == 0 ? "x" : "+x")));
                    strT = strT + (y == 0 ? "" : (y < 0 ? "-y" : (strT.length() == 0 ? "y" : "+y")));
                    strT = strT + (z == 0 ? "" : (z < 0 ? "-z" : (strT.length() == 0 ? "z" : "+z")));
                    strT = strT + (iValue == 0.0f ? "" : (iValue < 0.0f ? "" + iValue : "+" + iValue));
                    strOut = strOut + (strOut == "" ? "" : ",") + strT;
                    if (rowPt == 2) {
                        this.operation.set(temp);
                        this.xyz = strOut;
                        rowPt = 0;
                        return true;
                    }
                    z = 0;
                    y = 0;
                    x = 0;
                    iValue = 0.0f;
                    break;
                }
                case '.': {
                    isDecimal = true;
                    decimalMultiplier = 1.0f;
                    continue block12;
                }
                case '0': {
                    if (!isDecimal) continue block12;
                }
                default: {
                    int ich = ch - 48;
                    if (isDecimal && ich >= 0 && ich <= 9) {
                        iValue += (decimalMultiplier /= 10.0f) * (float)ich;
                        continue block12;
                    }
                    if (ich >= 1 && ich <= 9) {
                        if (isDenominator) {
                            iValue /= (float)ich;
                            break;
                        }
                        iValue = (isNegative ? -1.0f : 1.0f) * (float)ich;
                        break;
                    }
                    Logger.warn("symmetry character?" + ch);
                }
            }
            isDenominator = false;
            isDecimal = false;
            isNegative = isInverted;
        }
        return false;
    }

    void newPoint(Atom atom1, Atom atom2, boolean normalize, int transX, int transY, int transZ) {
        Point4f temp = new Point4f(atom1.x, atom1.y, atom1.z, 1.0f);
        this.operation.transform(temp, temp);
        if (normalize) {
            while (temp.x > 1.0f) {
                temp.x -= 1.0f;
            }
            while (temp.y > 1.0f) {
                temp.y -= 1.0f;
            }
            while (temp.z > 1.0f) {
                temp.z -= 1.0f;
            }
            while (temp.x < 0.0f) {
                temp.x += 1.0f;
            }
            while (temp.y < 0.0f) {
                temp.y += 1.0f;
            }
            while (temp.z < 0.0f) {
                temp.z += 1.0f;
            }
        }
        atom2.x = temp.x + (float)transX;
        atom2.y = temp.y + (float)transY;
        atom2.z = temp.z + (float)transZ;
    }

    void setOffset(Atom[] atoms, int atomIndex, int count) {
        int i1 = atomIndex;
        int i2 = i1 + count;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (int i = i1; i < i2; ++i) {
            this.newPoint(atoms[i], this.atomTest, false, 0, 0, 0);
            x += this.atomTest.x;
            y += this.atomTest.y;
            z += this.atomTest.z;
        }
        if ((double)x < -0.001 || (double)x >= (double)count + 0.001) {
            this.operation.m03 = this.operation.m03 + (float)(x < 0.0f ? 1 : -1);
        }
        if ((double)y < -0.001 || (double)y >= (double)count + 0.001) {
            this.operation.m13 = this.operation.m13 + (float)(y < 0.0f ? 1 : -1);
        }
        if ((double)z < -0.001 || (double)z >= (double)count + 0.001) {
            this.operation.m23 = this.operation.m23 + (float)(z < 0.0f ? 1 : -1);
        }
    }
}

