/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.SpartanArchive;

class SpartanSmolReader
extends AtomSetCollectionReader {
    final boolean debugReader = false;
    boolean isCompoundDocument;
    String modelName = "Spartan file";
    int atomCount;
    String line;
    int desiredModelNumber;
    int modelNumber = 0;
    Hashtable moData = new Hashtable();

    SpartanSmolReader() {
    }

    void initialize() {
        this.desiredModelNumber = -1;
    }

    void initialize(int[] params) {
        this.initialize();
        if (params == null) {
            return;
        }
        this.desiredModelNumber = params[0];
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.line = reader.readLine();
        this.isCompoundDocument = this.line.indexOf("Compound Document") >= 0;
        this.atomSetCollection = new AtomSetCollection("spartan " + (this.isCompoundDocument ? "compound document file" : "smol"));
        String bondData = "";
        SpartanArchive spartanArchive = null;
        try {
            while (this.line != null) {
                if (this.line.equals("HESSIAN") && bondData != null) {
                    while ((this.line = reader.readLine()) != null && this.line.indexOf("ENDHESS") < 0) {
                        bondData = bondData + this.line + " ";
                    }
                }
                if (this.line.equals("BEGINARCHIVE") || this.line.equals("BEGIN Compound Document Entry: Archive")) {
                    spartanArchive = new SpartanArchive(this, this.logger, this.atomSetCollection, this.moData, bondData);
                    bondData = null;
                    String infoLine = this.readArchiveHeader(reader);
                    this.atomCount = spartanArchive.readArchive(reader, infoLine, false);
                    if (this.atomCount > 0) {
                        this.atomSetCollection.setAtomSetName(this.modelName);
                    }
                } else if (this.atomCount > 0 && this.line.indexOf("BEGINPROPARC") == 0 || this.line.equals("BEGIN Compound Document Entry: PropertyArchive")) {
                    spartanArchive.readProperties(reader);
                    if (!this.atomSetCollection.setAtomSetCollectionPartialCharges("MULCHARGES")) {
                        this.atomSetCollection.setAtomSetCollectionPartialCharges("Q1_CHARGES");
                    }
                }
                this.line = reader.readLine();
            }
        }
        catch (Exception e) {
            this.logger.log(e + " at line: " + this.line);
            e.printStackTrace();
            new NullPointerException();
        }
        if (this.atomCount > 0 && spartanArchive != null && bondData != null) {
            spartanArchive.addBonds(bondData);
        }
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    String readArchiveHeader(BufferedReader reader) throws Exception {
        String modelInfo = reader.readLine();
        this.logger.log(modelInfo);
        this.atomSetCollection.setCollectionName(modelInfo);
        this.modelName = reader.readLine();
        this.logger.log(this.modelName);
        return reader.readLine();
    }
}

