/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.SpartanArchive;

class SpartanReader
extends AtomSetCollectionReader {
    String modelName = "Spartan file";
    int atomCount;
    String line;
    Hashtable moData = new Hashtable();

    SpartanReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.atomSetCollection = new AtomSetCollection("spartan");
        String cartesianHeader = "Cartesian Coordinates (Ang";
        try {
            if (this.isSpartanArchive(reader, cartesianHeader)) {
                SpartanArchive spartanArchive = new SpartanArchive(this, this.logger, this.atomSetCollection, this.moData);
                this.atomCount = spartanArchive.readArchive(reader, this.line, true);
                if (this.atomCount > 0) {
                    this.atomSetCollection.setAtomSetName(this.modelName);
                }
            } else if (this.line.indexOf(cartesianHeader) >= 0) {
                this.readAtoms(reader);
                if (this.discardLinesUntilContains(reader, "Vibrational Frequencies") != null) {
                    this.readFrequencies(reader);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
            return this.atomSetCollection;
        }
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    boolean isSpartanArchive(BufferedReader reader, String strNotArchive) throws Exception {
        String lastLine = "";
        while ((this.line = reader.readLine()) != null) {
            if (this.line.equals("GEOMETRY")) {
                this.line = lastLine;
                return true;
            }
            if (this.line.indexOf(strNotArchive) >= 0) {
                return false;
            }
            lastLine = this.line;
        }
        return false;
    }

    void readAtoms(BufferedReader reader) throws Exception {
        String line;
        this.discardLinesUntilBlank(reader);
        while ((line = reader.readLine()) != null && this.parseInt(line, 0, 3) > 0) {
            String elementSymbol = this.parseToken(line, 4, 6);
            String atomName = this.parseToken(line, 7, 13);
            float x = this.parseFloat(line, 17, 30);
            float y = this.parseFloat(line, 31, 44);
            float z = this.parseFloat(line, 45, 58);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = elementSymbol;
            atom.atomName = atomName;
            atom.x = x;
            atom.y = y;
            atom.z = z;
        }
    }

    void readFrequencies(BufferedReader reader) throws Exception {
        int totalFrequencyCount = 0;
        block0: while (true) {
            float frequency;
            int lineFreqCount;
            String line = this.discardLinesUntilNonBlank(reader);
            int lineBaseFreqCount = totalFrequencyCount;
            this.ichNextParse = 16;
            for (lineFreqCount = 0; lineFreqCount < 3 && !Float.isNaN(frequency = this.parseFloat(line, this.ichNextParse)); ++lineFreqCount) {
                if (++totalFrequencyCount <= 1) continue;
                this.atomSetCollection.cloneFirstAtomSet();
            }
            if (lineFreqCount == 0) {
                return;
            }
            Atom[] atoms = this.atomSetCollection.atoms;
            this.discardLines(reader, 2);
            int firstAtomSetAtomCount = this.atomSetCollection.getFirstAtomSetAtomCount();
            int i = 0;
            while (true) {
                if (i >= firstAtomSetAtomCount) continue block0;
                line = reader.readLine();
                for (int j = 0; j < lineFreqCount; ++j) {
                    int ichCoords = j * 23 + 10;
                    float x = this.parseFloat(line, ichCoords, ichCoords + 7);
                    float y = this.parseFloat(line, ichCoords + 7, ichCoords + 14);
                    float z = this.parseFloat(line, ichCoords + 14, ichCoords + 21);
                    int atomIndex = (lineBaseFreqCount + j) * firstAtomSetAtomCount + i;
                    Atom atom = atoms[atomIndex];
                    atom.vectorX = x;
                    atom.vectorY = y;
                    atom.vectorZ = z;
                }
                ++i;
            }
            break;
        }
    }
}

