/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;

class SpartanArchive {
    int atomCount = 0;
    String bondData;
    int bondCount = 0;
    int moCount = 0;
    int shellCount = 0;
    int gaussianCount = 0;
    String calculationType = "";
    String line;
    JmolAdapter.Logger logger;
    AtomSetCollection atomSetCollection;
    AtomSetCollectionReader r;
    Hashtable moData;
    Vector orbitals = new Vector();

    SpartanArchive(AtomSetCollectionReader r, JmolAdapter.Logger logger, AtomSetCollection atomSetCollection, Hashtable moData) {
        this.initialize(r, logger, atomSetCollection, moData, "");
    }

    SpartanArchive(AtomSetCollectionReader r, JmolAdapter.Logger logger, AtomSetCollection atomSetCollection, Hashtable moData, String bondData) {
        this.initialize(r, logger, atomSetCollection, moData, bondData);
    }

    private void initialize(AtomSetCollectionReader r, JmolAdapter.Logger logger, AtomSetCollection atomSetCollection, Hashtable moData, String bondData) {
        this.logger = logger;
        this.r = r;
        this.atomSetCollection = atomSetCollection;
        this.moData = moData;
        moData.put("energyUnits", "");
        this.bondData = bondData;
    }

    int readArchive(BufferedReader reader, String infoLine, boolean haveGeometryLine) throws Exception {
        this.atomCount = this.setInfo(infoLine);
        this.line = haveGeometryLine ? "GEOMETRY" : "";
        try {
            while (this.line != null) {
                if (this.line.equals("GEOMETRY")) {
                    this.readAtoms(reader);
                    if (this.bondData.length() > 0) {
                        this.addBonds(this.bondData);
                    }
                } else if (this.line.indexOf("BASIS") == 0) {
                    this.readBasis(reader);
                } else if (this.line.indexOf("WAVEFUNC") == 0 || this.line.indexOf("BETA") == 0) {
                    this.readMolecularOrbital(reader);
                    this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", this.moData);
                } else if (this.line.equals("ENDARCHIVE") || this.line.equals("END Compound Document Entry: Archive")) break;
                this.line = reader.readLine();
            }
        }
        catch (Exception e) {
            this.logger.log("Spartan archive reader error on line: " + this.line);
            e.printStackTrace();
            new Exception(e);
        }
        return this.atomCount;
    }

    String[] getTokens(String info) {
        return this.r.getTokens(info);
    }

    int parseInt(String info) {
        return this.r.parseInt(info);
    }

    float parseFloat(String info) {
        return this.r.parseFloat(info);
    }

    int setInfo(String info) throws Exception {
        String[] tokens = this.getTokens(info);
        this.logger.log("reading Spartan archive info :" + info);
        this.atomCount = this.parseInt(tokens[0]);
        this.moCount = this.parseInt(tokens[1]);
        this.shellCount = this.parseInt(tokens[2]);
        this.gaussianCount = this.parseInt(tokens[3]);
        this.calculationType = tokens[9];
        this.moData.put("calculationType", this.calculationType);
        return this.atomCount;
    }

    void readAtoms(BufferedReader reader) throws Exception {
        for (int i = 0; i < this.atomCount; ++i) {
            this.line = reader.readLine();
            String[] tokens = this.getTokens(this.line);
            float x = this.parseFloat(tokens[1]);
            float y = this.parseFloat(tokens[2]);
            float z = this.parseFloat(tokens[3]);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol(this.parseInt(tokens[0]));
            atom.x = x * 0.5291772f;
            atom.y = y * 0.5291772f;
            atom.z = z * 0.5291772f;
        }
        this.logger.log(this.atomCount + " atoms read");
    }

    void addBonds(String data) {
        this.addBonds(data, 0);
    }

    void addBonds(String data, int atomCount0) {
        String[] tokens = this.getTokens(data);
        this.bondCount = 0;
        int i = this.atomCount;
        while (i < tokens.length) {
            int bondOrder;
            int sourceIndex = this.parseInt(tokens[i++]) - 1 + atomCount0;
            int targetIndex = this.parseInt(tokens[i++]) - 1 + atomCount0;
            if ((bondOrder = this.parseInt(tokens[i++])) <= 0) continue;
            this.atomSetCollection.addBond(new Bond(sourceIndex, targetIndex, bondOrder < 4 ? bondOrder : 1));
            ++this.bondCount;
        }
        this.logger.log(this.bondCount + " bonds read");
    }

    void readBasis(BufferedReader reader) throws Exception {
        int i;
        Vector sdata = new Vector();
        float[][] garray = new float[this.gaussianCount][];
        int[] typeArray = new int[this.gaussianCount];
        for (i = 0; i < this.shellCount; ++i) {
            String basisType;
            this.line = reader.readLine();
            String[] tokens = this.getTokens(this.line);
            Hashtable<String, Object> slater = new Hashtable<String, Object>();
            int iBasis = this.parseInt(tokens[0]);
            switch (iBasis) {
                case 0: {
                    basisType = "S";
                    break;
                }
                case 1: {
                    basisType = "SP";
                    break;
                }
                case 2: {
                    basisType = "D";
                    break;
                }
                case 3: {
                    basisType = "F";
                    break;
                }
                default: {
                    basisType = "SMOL unknown basis type will be ignored: " + iBasis;
                }
            }
            int nGaussians = this.parseInt(tokens[1]);
            int gaussianPtr = this.parseInt(tokens[2]) - 1;
            for (int j = 0; j < nGaussians; ++j) {
                typeArray[gaussianPtr + j] = iBasis;
            }
            slater.put("atomIndex", new Integer(this.parseInt(tokens[3]) - 1));
            slater.put("basisType", basisType);
            slater.put("nGaussians", new Integer(nGaussians));
            slater.put("gaussianPtr", new Integer(gaussianPtr));
            sdata.add(slater);
        }
        for (i = 0; i < this.gaussianCount; ++i) {
            this.line = reader.readLine();
            float alpha = this.parseFloat(this.line);
            this.line = reader.readLine();
            String[] tokens = this.getTokens(this.line);
            int nData = tokens.length;
            float[] data = new float[nData + 1];
            data[0] = alpha;
            int iBasis = typeArray[i];
            switch (iBasis) {
                case 1: {
                    data[2] = this.parseFloat(tokens[1]);
                }
                case 0: {
                    data[1] = this.parseFloat(tokens[0]);
                    break;
                }
                case 2: {
                    data[1] = this.parseFloat(tokens[2]);
                    break;
                }
                case 3: {
                    data[1] = this.parseFloat(tokens[3]);
                }
            }
            garray[i] = data;
        }
        this.moData.put("shells", sdata);
        this.moData.put("gaussians", garray);
        this.logger.log(sdata.size() + " slater shells read");
        this.logger.log(garray.length + " gaussian primitives read");
    }

    void readMolecularOrbital(BufferedReader reader) throws Exception {
        int i;
        int tokenPt = 0;
        String[] tokens = this.getTokens("");
        float[] energies = new float[this.moCount];
        float[][] coefficients = new float[this.moCount][this.moCount];
        for (i = 0; i < this.moCount; ++i) {
            if (tokenPt == tokens.length) {
                this.line = reader.readLine();
                tokens = this.getTokens(this.line);
                tokenPt = 0;
            }
            energies[i] = this.parseFloat(tokens[tokenPt++]);
        }
        for (i = 0; i < this.moCount; ++i) {
            for (int j = 0; j < this.moCount; ++j) {
                if (tokenPt == tokens.length) {
                    this.line = reader.readLine();
                    tokens = this.getTokens(this.line);
                    tokenPt = 0;
                }
                coefficients[i][j] = this.parseFloat(tokens[tokenPt++]);
            }
        }
        for (i = 0; i < this.moCount; ++i) {
            Hashtable<String, Object> mo = new Hashtable<String, Object>();
            mo.put("energy", new Float(energies[i]));
            mo.put("coefficients", coefficients[i]);
            this.orbitals.add(mo);
        }
        this.logger.log(this.orbitals.size() + " molecular orbitals read");
        this.moData.put("mos", this.orbitals);
    }

    void readProperties(BufferedReader reader) throws Exception {
        this.logger.log("Reading PROPARC properties records...");
        while (!((this.line = reader.readLine()) == null || this.line.length() >= 10 && this.line.substring(0, 10).equals("ENDPROPARC"))) {
            if (this.line.length() >= 4 && this.line.substring(0, 4).equals("PROP")) {
                this.readProperty(reader);
            }
            if (this.line.length() >= 6 && this.line.substring(0, 6).equals("DIPOLE")) {
                this.readDipole(reader);
            }
            if (this.line.length() < 7 || !this.line.substring(0, 7).equals("VIBFREQ")) continue;
            this.readVibFreqs(reader);
        }
    }

    void readDipole(BufferedReader reader) throws Exception {
        this.line = reader.readLine();
        String[] tokens = this.getTokens(this.line);
        if (tokens.length != 3) {
            return;
        }
        Vector3f dipole = new Vector3f(this.parseFloat(tokens[0]), this.parseFloat(tokens[1]), this.parseFloat(tokens[2]));
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("dipole", dipole);
    }

    void readProperty(BufferedReader reader) throws Exception {
        String[] tokens = this.getTokens(this.line);
        if (tokens.length == 0) {
            return;
        }
        boolean isString = tokens[1].equals("STRING");
        String keyName = tokens[2];
        Object value = new Object();
        Vector<Object> vector = new Vector<Object>();
        if (tokens[3].equals("=")) {
            value = isString ? this.getString(this.line, tokens[4].substring(0, 1)) : new Float(this.parseFloat(tokens[4]));
        } else if (tokens[tokens.length - 1].equals("BEGIN")) {
            int nValues = this.parseInt(tokens[tokens.length - 2]);
            if (nValues == 0) {
                nValues = 1;
            }
            boolean isArray = tokens.length == 6;
            Vector<Float> atomInfo = new Vector<Float>();
            while ((this.line = reader.readLine()) != null && !this.line.substring(0, 3).equals("END")) {
                if (isString) {
                    value = this.getString(this.line, "\"");
                    vector.add(value);
                    continue;
                }
                String[] tokens2 = this.getTokens(this.line);
                for (int i = 0; i < tokens2.length; ++i) {
                    if (isArray) {
                        atomInfo.add(new Float(this.parseFloat(tokens2[i])));
                        if ((i + 1) % nValues != 0) continue;
                        vector.add(atomInfo);
                        atomInfo = new Vector();
                        continue;
                    }
                    value = new Float(this.parseFloat(tokens2[i]));
                    vector.add(value);
                }
            }
            value = null;
        } else {
            this.logger.log(" Skipping property line " + this.line);
        }
        if (value != null) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo(keyName, value);
        }
        if (vector.size() != 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo(keyName, vector);
        }
    }

    void readVibFreqs(BufferedReader reader) throws Exception {
        this.line = reader.readLine();
        String label = "";
        int frequencyCount = this.parseInt(this.line);
        Vector vibrations = new Vector();
        Vector freqs = new Vector();
        this.logger.log("reading VIBFREQ vibration records: frequencyCount = " + frequencyCount);
        for (int i = 0; i < frequencyCount; ++i) {
            int atomCount0 = this.atomSetCollection.atomCount;
            this.atomSetCollection.cloneLastAtomSet();
            this.addBonds(this.bondData, atomCount0);
            this.line = reader.readLine();
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            float freq = this.parseFloat(this.line);
            info.put("freq", new Float(freq));
            if (this.line.length() > 15 && !(label = this.line.substring(15, this.line.length())).equals("???")) {
                info.put("label", label);
            }
            freqs.add(info);
            this.atomSetCollection.setAtomSetName(label + " " + freq + " cm^-1");
            this.atomSetCollection.setAtomSetProperty(".PATH", "Frequencies");
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("VibFreqs", freqs);
        int atomCount = this.atomSetCollection.getFirstAtomSetAtomCount();
        Atom[] atoms = this.atomSetCollection.atoms;
        Vector vib = new Vector();
        Vector<Float> vibatom = new Vector<Float>();
        int ifreq = 0;
        int iatom = atomCount;
        int nValues = 3;
        float[] atomInfo = new float[3];
        while ((this.line = reader.readLine()) != null) {
            String[] tokens2 = this.getTokens(this.line);
            for (int i = 0; i < tokens2.length; ++i) {
                float f;
                atomInfo[i % nValues] = f = this.parseFloat(tokens2[i]);
                vibatom.add(new Float(f));
                if ((i + 1) % nValues != 0) continue;
                atoms[iatom].addVibrationVector(atomInfo[0], atomInfo[1], atomInfo[2]);
                vib.add(vibatom);
                vibatom = new Vector();
                ++iatom;
            }
            if (iatom % atomCount != 0) continue;
            vibrations.add(vib);
            vib = new Vector();
            if (++ifreq != frequencyCount) continue;
            break;
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("vibration", vibrations);
    }

    String getString(String line, String strQuote) {
        int i = line.indexOf(strQuote);
        int j = line.lastIndexOf(strQuote);
        return j == i ? "" : line.substring(i + 1, j);
    }
}

