/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;

class MolReader
extends AtomSetCollectionReader {
    MolReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.atomSetCollection = new AtomSetCollection("mol");
        String firstLine = reader.readLine();
        if (firstLine.startsWith("$MDL")) {
            this.processRgHeader(reader, firstLine);
            while (!reader.readLine().startsWith("$CTAB")) {
            }
            this.processCtab(reader);
        } else {
            this.processMolSdHeader(reader, firstLine);
            this.processCtab(reader);
        }
        return this.atomSetCollection;
    }

    void processMolSdHeader(BufferedReader reader, String firstLine) throws Exception {
        String header = firstLine + "\n";
        this.atomSetCollection.setCollectionName(firstLine);
        header = header + reader.readLine() + "\n";
        String comment = reader.readLine();
        header = header + comment + "\n";
        this.checkLineForScript(comment);
        this.atomSetCollection.setAtomSetCollectionProperty("fileHeader", header);
    }

    void processRgHeader(BufferedReader reader, String firstLine) throws Exception {
        String line;
        while ((line = reader.readLine()) != null && !line.startsWith("$HDR")) {
        }
        if (line == null) {
            this.logger.log("$HDR not found in MDL RG file");
            return;
        }
        this.processMolSdHeader(reader, reader.readLine());
    }

    void processCtab(BufferedReader reader) throws Exception {
        String countLine = reader.readLine();
        int atomCount = this.parseInt(countLine, 0, 3);
        int bondCount = this.parseInt(countLine, 3, 6);
        this.readAtoms(reader, atomCount);
        this.readBonds(reader, bondCount);
    }

    void readAtoms(BufferedReader reader, int atomCount) throws Exception {
        for (int i = 0; i < atomCount; ++i) {
            int chargeCode;
            String line = reader.readLine();
            String elementSymbol = "";
            elementSymbol = line.length() > 34 ? line.substring(31, 34).trim().intern() : line.substring(31).trim().intern();
            float x = this.parseFloat(line, 0, 10);
            float y = this.parseFloat(line, 10, 20);
            float z = this.parseFloat(line, 20, 30);
            int charge = 0;
            if (line.length() >= 39 && (chargeCode = this.parseInt(line, 36, 39)) >= 1 && chargeCode <= 7) {
                charge = 4 - chargeCode;
            }
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = elementSymbol;
            atom.formalCharge = charge;
            atom.x = x;
            atom.y = y;
            atom.z = z;
        }
    }

    void readBonds(BufferedReader reader, int bondCount) throws Exception {
        for (int i = 0; i < bondCount; ++i) {
            String line = reader.readLine();
            int atomIndex1 = this.parseInt(line, 0, 3);
            int atomIndex2 = this.parseInt(line, 3, 6);
            int order = this.parseInt(line, 6, 9);
            if (order == 4) {
                order = 4;
            }
            this.atomSetCollection.addBond(new Bond(atomIndex1 - 1, atomIndex2 - 1, order));
        }
    }
}

