/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;

class Mol2Reader
extends AtomSetCollectionReader {
    String line;
    int desiredModelNumber;
    int modelNumber = 0;
    int nAtoms = 0;

    Mol2Reader() {
    }

    void initialize() {
        this.desiredModelNumber = -1;
    }

    void initialize(int[] params) {
        this.initialize();
        if (params == null) {
            return;
        }
        this.desiredModelNumber = params[0];
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.atomSetCollection = new AtomSetCollection("mol2");
        this.line = reader.readLine();
        this.modelNumber = 0;
        while (this.line != null) {
            if (this.line.equals("@<TRIPOS>MOLECULE") && (++this.modelNumber == this.desiredModelNumber || this.desiredModelNumber <= 0)) {
                try {
                    this.processMolecule(reader);
                }
                catch (Exception e) {
                    this.logger.log(e + " at line: " + this.line);
                    e.printStackTrace();
                    new NullPointerException();
                }
                if (this.desiredModelNumber <= 0) continue;
                break;
            }
            this.line = reader.readLine();
        }
        return this.atomSetCollection;
    }

    void processMolecule(BufferedReader reader) throws Exception {
        String thisDataSetName = reader.readLine().trim();
        this.line = reader.readLine() + " 0 0 0 0 0 0";
        int atomCount = this.parseInt(this.line);
        int bondCount = this.parseInt(this.line, this.ichNextParse);
        int resCount = this.parseInt(this.line, this.ichNextParse);
        reader.readLine();
        this.line = reader.readLine();
        boolean iHaveCharges = this.line.indexOf("NO_CHARGES") != 0;
        this.line = reader.readLine();
        if (this.line != null && this.line.charAt(0) != '@') {
            this.line = reader.readLine();
            if (this.line != null && this.line.charAt(0) != '@') {
                thisDataSetName = thisDataSetName + ": " + reader.readLine().trim();
                this.line = reader.readLine();
            }
        }
        if (this.atomSetCollection.currentAtomSetIndex >= 0) {
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setCollectionName("<collection of " + (this.atomSetCollection.currentAtomSetIndex + 1) + " models>");
        } else {
            this.atomSetCollection.setCollectionName(thisDataSetName);
        }
        this.logger.log(thisDataSetName);
        while (this.line != null && !this.line.equals("@<TRIPOS>MOLECULE")) {
            if (this.line.equals("@<TRIPOS>ATOM")) {
                this.readAtoms(reader, atomCount, iHaveCharges);
                this.atomSetCollection.setAtomSetName(thisDataSetName);
            } else if (this.line.equals("@<TRIPOS>BOND")) {
                this.readBonds(reader, bondCount);
            } else if (this.line.equals("@<TRIPOS>SUBSTRUCTURE")) {
                this.readResInfo(reader, resCount);
            } else if (this.line.equals("@<TRIPOS>CRYSIN")) {
                this.readCrystalInfo(reader);
            }
            this.line = reader.readLine();
        }
        this.nAtoms += atomCount;
    }

    void readAtoms(BufferedReader reader, int atomCount, boolean iHaveCharges) throws Exception {
        for (int i = 0; i < atomCount; ++i) {
            Atom atom = this.atomSetCollection.addNewAtom();
            this.line = reader.readLine();
            String[] tokens = this.getTokens(this.line);
            atom.x = this.parseFloat(tokens[2]);
            atom.y = this.parseFloat(tokens[3]);
            atom.z = this.parseFloat(tokens[4]);
            String elementSymbol = tokens[5];
            if (elementSymbol.length() > 1 && elementSymbol.charAt(1) == '.') {
                elementSymbol = elementSymbol.substring(0, 1);
            }
            if (elementSymbol.length() > 2) {
                elementSymbol = elementSymbol.substring(0, 2);
            }
            atom.elementSymbol = elementSymbol;
            if (!iHaveCharges) continue;
            atom.partialCharge = this.parseFloat(tokens[8]);
        }
    }

    void readBonds(BufferedReader reader, int bondCount) throws Exception {
        for (int i = 0; i < bondCount; ++i) {
            String line = reader.readLine();
            String[] tokens = this.getTokens(line);
            int atomIndex1 = this.parseInt(tokens[1]);
            int atomIndex2 = this.parseInt(tokens[2]);
            int order = this.parseInt(tokens[3]);
            if (order == Integer.MIN_VALUE) {
                order = tokens[3].equals("ar") ? 4 : 1;
            }
            this.atomSetCollection.addBond(new Bond(this.nAtoms + atomIndex1 - 1, this.nAtoms + atomIndex2 - 1, order));
        }
    }

    void readResInfo(BufferedReader reader, int resCount) throws Exception {
        for (int i = 0; i < resCount; ++i) {
            reader.readLine();
        }
    }

    void readCrystalInfo(BufferedReader reader) throws Exception {
        this.line = reader.readLine();
        float[] notionalUnitcell = new float[6];
        this.ichNextParse = 0;
        for (int i = 0; i < 6; ++i) {
            notionalUnitcell[i] = this.parseFloat(this.line, this.ichNextParse);
        }
        this.atomSetCollection.setNotionalUnitcell(notionalUnitcell, this.logger);
        String spaceGroup = this.line.substring(this.ichNextParse, this.line.length()).trim();
        this.atomSetCollection.setAtomSetSpaceGroup(spaceGroup);
    }
}

