/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.StringTokenizer;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;

class JmeReader
extends AtomSetCollectionReader {
    String line;
    StringTokenizer tokenizer;

    JmeReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.atomSetCollection = new AtomSetCollection("jme");
        try {
            this.line = reader.readLine();
            this.tokenizer = new StringTokenizer(this.line, "\t ");
            int atomCount = this.parseInt(this.tokenizer.nextToken());
            int bondCount = this.parseInt(this.tokenizer.nextToken());
            this.atomSetCollection.setCollectionName("JME");
            this.readAtoms(atomCount);
            this.readBonds(bondCount);
        }
        catch (Exception ex) {
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
            this.logger.log(this.atomSetCollection.errorMessage);
        }
        return this.atomSetCollection;
    }

    void readAtoms(int atomCount) throws Exception {
        for (int i = 0; i < atomCount; ++i) {
            String strAtom = this.tokenizer.nextToken();
            int indexColon = strAtom.indexOf(58);
            String elementSymbol = (indexColon > 0 ? strAtom.substring(0, indexColon) : strAtom).intern();
            float x = this.parseFloat(this.tokenizer.nextToken());
            float y = this.parseFloat(this.tokenizer.nextToken());
            float z = 0.0f;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = elementSymbol;
            atom.x = x;
            atom.y = y;
            atom.z = z;
        }
    }

    void readBonds(int bondCount) throws Exception {
        for (int i = 0; i < bondCount; ++i) {
            int atomIndex1 = this.parseInt(this.tokenizer.nextToken());
            int atomIndex2 = this.parseInt(this.tokenizer.nextToken());
            int order = this.parseInt(this.tokenizer.nextToken());
            if (order < 1) {
                order = order == -1 ? 9 : 18;
            }
            this.atomSetCollection.addBond(new Bond(atomIndex1 - 1, atomIndex2 - 1, order));
        }
    }
}

