/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.StringTokenizer;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

class JaguarReader
extends AtomSetCollectionReader {
    int atomCount;

    JaguarReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.atomSetCollection = new AtomSetCollection("jaguar");
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("  final geometry:")) {
                    this.readAtoms(reader);
                    continue;
                }
                if (!line.startsWith("  harmonic frequencies in")) continue;
                this.readFrequencies(reader);
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
            return this.atomSetCollection;
        }
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    void readAtoms(BufferedReader reader) throws Exception {
        String line;
        this.atomSetCollection.discardPreviousAtoms();
        this.discardLines(reader, 2);
        while ((line = reader.readLine()) != null && line.length() >= 60 && line.charAt(2) != ' ') {
            String atomName = this.parseToken(line, 2, 7);
            float x = this.parseFloat(line, 8, 24);
            float y = this.parseFloat(line, 26, 42);
            float z = this.parseFloat(line, 44, 60);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) {
                return;
            }
            int len = atomName.length();
            if (len < 2) {
                return;
            }
            char ch2 = atomName.charAt(1);
            String elementSymbol = ch2 >= 'a' && ch2 <= 'z' ? atomName.substring(0, 2) : atomName.substring(0, 1);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = elementSymbol;
            atom.atomName = atomName;
            atom.x = x;
            atom.y = y;
            atom.z = z;
        }
    }

    void readFrequencies(BufferedReader reader) throws Exception {
        String line;
        this.atomCount = this.atomSetCollection.getFirstAtomSetAtomCount();
        int modelNumber = 1;
        while ((line = reader.readLine()) != null && !line.startsWith("  frequencies ")) {
        }
        if (line == null) {
            return;
        }
        do {
            int freqCount = new StringTokenizer(line).countTokens() - 1;
            while ((line = reader.readLine()) != null && !line.startsWith("  intensities ")) {
            }
            for (int atomCenterNumber = 0; atomCenterNumber < this.atomCount; ++atomCenterNumber) {
                line = reader.readLine();
                StringTokenizer tokenizerX = new StringTokenizer(line);
                tokenizerX.nextToken();
                tokenizerX.nextToken();
                StringTokenizer tokenizerY = new StringTokenizer(reader.readLine());
                tokenizerY.nextToken();
                tokenizerY.nextToken();
                StringTokenizer tokenizerZ = new StringTokenizer(reader.readLine());
                tokenizerZ.nextToken();
                tokenizerZ.nextToken();
                for (int j = 0; j < freqCount; ++j) {
                    float x = this.parseFloat(tokenizerX.nextToken());
                    float y = this.parseFloat(tokenizerY.nextToken());
                    float z = this.parseFloat(tokenizerZ.nextToken());
                    this.recordAtomVector(modelNumber + j, atomCenterNumber, x, y, z);
                }
            }
            this.discardLines(reader, 1);
            modelNumber += freqCount;
        } while ((line = reader.readLine()) != null && line.startsWith("  frequencies "));
    }

    void recordAtomVector(int modelNumber, int atomCenterNumber, float x, float y, float z) {
        if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) {
            return;
        }
        if (atomCenterNumber <= 0 || atomCenterNumber > this.atomCount) {
            return;
        }
        if (atomCenterNumber == 1 && modelNumber > 1) {
            this.atomSetCollection.cloneFirstAtomSet();
        }
        Atom atom = this.atomSetCollection.atoms[(modelNumber - 1) * this.atomCount + atomCenterNumber - 1];
        atom.vectorX = x;
        atom.vectorY = y;
        atom.vectorZ = z;
    }

    void discardLines(BufferedReader reader, int nLines) throws Exception {
        int i = nLines;
        while (--i >= 0) {
            reader.readLine();
        }
    }
}

