/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

class GamessReader
extends AtomSetCollectionReader {
    static final float angstromsPerBohr = 0.529177f;
    String line;
    int atomCount = 0;
    int moCount = 0;
    int shellCount = 0;
    int gaussianCount = 0;
    String calculationType = "?";
    Hashtable moData = new Hashtable();
    Vector orbitals = new Vector();

    GamessReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.atomSetCollection = new AtomSetCollection("gamess");
        this.line = reader.readLine();
        try {
            while (this.line != null) {
                if (this.line.indexOf("COORDINATES (BOHR)") >= 0) {
                    this.readAtomsInBohrCoordinates(reader);
                } else if (this.line.indexOf("FREQUENCIES IN CM") >= 0) {
                    this.readFrequencies(reader);
                } else {
                    if (this.line.indexOf("ATOMIC BASIS SET") >= 0) {
                        this.readGaussianBasis(reader);
                        continue;
                    }
                    if (this.line.indexOf("EIGENVECTORS") >= 0) {
                        this.readMolecularOrbitals(reader);
                        continue;
                    }
                }
                this.line = reader.readLine();
            }
        }
        catch (Exception e) {
            this.logger.log(e + " at line: " + this.line);
            e.printStackTrace();
            new NullPointerException();
        }
        this.logger.log(this.orbitals.size() + " molecular orbitals read");
        this.moData.put("calculationType", this.calculationType);
        this.moData.put("mos", this.orbitals);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", this.moData);
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    void readAtomsInBohrCoordinates(BufferedReader reader) throws Exception {
        String atomName;
        String line;
        reader.readLine();
        this.atomSetCollection.newAtomSet();
        while ((line = reader.readLine()) != null && (atomName = this.parseToken(line, 1, 6)) != null) {
            float x = this.parseFloat(line, 17, 37);
            float y = this.parseFloat(line, 37, 57);
            float z = this.parseFloat(line, 57, 77);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) break;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = atomName;
            atom.x = x * 0.529177f;
            atom.y = y * 0.529177f;
            atom.z = z * 0.529177f;
        }
    }

    void readGaussianBasis(BufferedReader reader) throws Exception {
        String[] tokens;
        Vector sdata = new Vector();
        Vector<String[]> gdata = new Vector<String[]>();
        this.atomCount = 0;
        this.gaussianCount = 0;
        int nGaussians = 0;
        this.shellCount = 0;
        String thisShell = "0";
        this.discardLinesUntilContains(reader, "SHELL TYPE PRIMITIVE");
        reader.readLine();
        Hashtable<String, Integer> slater = null;
        block4: while ((this.line = reader.readLine()) != null && this.line.indexOf("TOTAL") < 0) {
            tokens = this.getTokens(this.line);
            switch (tokens.length) {
                case 1: {
                    ++this.atomCount;
                }
                case 0: {
                    continue block4;
                }
            }
            if (!tokens[0].equals(thisShell)) {
                if (slater != null) {
                    slater.put("nGaussians", new Integer(nGaussians));
                    sdata.add(slater);
                }
                thisShell = tokens[0];
                ++this.shellCount;
                slater = new Hashtable<String, Integer>();
                slater.put("atomIndex", new Integer(this.atomCount - 1));
                slater.put("basisType", (Integer)((Object)tokens[1]));
                slater.put("gaussianPtr", new Integer(this.gaussianCount));
                nGaussians = 0;
            }
            ++nGaussians;
            ++this.gaussianCount;
            gdata.add(tokens);
        }
        if (slater != null) {
            slater.put("nGaussians", new Integer(nGaussians));
            sdata.add(slater);
        }
        float[][] garray = new float[this.gaussianCount][];
        for (int i = 0; i < this.gaussianCount; ++i) {
            tokens = (String[])gdata.get(i);
            garray[i] = new float[tokens.length - 3];
            for (int j = 3; j < tokens.length; ++j) {
                garray[i][j - 3] = this.parseFloat(tokens[j]);
            }
        }
        this.moData.put("shells", sdata);
        this.moData.put("gaussians", garray);
        this.logger.log(this.shellCount + " slater shells read");
        this.logger.log(this.gaussianCount + " gaussian primitives read");
    }

    void readMolecularOrbitals(BufferedReader reader) throws Exception {
        Hashtable[] mos = new Hashtable[5];
        Vector[] data = new Vector[5];
        reader.readLine();
        int nThisLine = 0;
        while ((this.line = reader.readLine()) != null && this.line.indexOf("--") < 0) {
            int i;
            String[] tokens = this.getTokens(this.line);
            if (this.line.length() == 0) {
                for (i = 0; i < nThisLine; ++i) {
                    float[] coefs = new float[data[i].size()];
                    int j = coefs.length;
                    while (--j >= 0) {
                        coefs[j] = this.parseFloat((String)data[i].get(j));
                    }
                    mos[i].put("coefficients", coefs);
                    this.orbitals.add(mos[i]);
                }
                nThisLine = 0;
                continue;
            }
            if (nThisLine == 0) {
                nThisLine = tokens.length;
                tokens = this.getTokens(reader.readLine());
                for (i = 0; i < nThisLine; ++i) {
                    mos[i] = new Hashtable();
                    data[i] = new Vector();
                    mos[i].put("energy", new Float(tokens[i]));
                }
                tokens = this.getTokens(reader.readLine());
                for (i = 0; i < nThisLine; ++i) {
                    mos[i].put("symmetry", tokens[i]);
                }
                continue;
            }
            for (i = 0; i < nThisLine; ++i) {
                data[i].add(tokens[i + 4]);
            }
        }
    }

    void readFrequencies(BufferedReader reader) throws Exception {
        int totalFrequencyCount = 0;
        int atomCountInFirstModel = this.atomSetCollection.atomCount;
        float[] xComponents = new float[5];
        float[] yComponents = new float[5];
        float[] zComponents = new float[5];
        String line = this.discardLinesUntilContains(reader, "FREQUENCY:");
        while (line != null && line.indexOf("FREQUENCY:") >= 0) {
            float frequency;
            int lineFreqCount;
            int lineBaseFreqCount = totalFrequencyCount;
            this.ichNextParse = 17;
            for (lineFreqCount = 0; lineFreqCount < 5 && !Float.isNaN(frequency = this.parseFloat(line, this.ichNextParse)); ++lineFreqCount) {
                if (++totalFrequencyCount <= 1) continue;
                this.atomSetCollection.cloneFirstAtomSet();
            }
            Atom[] atoms = this.atomSetCollection.atoms;
            this.discardLinesUntilBlank(reader);
            for (int i = 0; i < atomCountInFirstModel; ++i) {
                this.readComponents(reader.readLine(), lineFreqCount, xComponents);
                this.readComponents(reader.readLine(), lineFreqCount, yComponents);
                this.readComponents(reader.readLine(), lineFreqCount, zComponents);
                for (int j = 0; j < lineFreqCount; ++j) {
                    int atomIndex = (lineBaseFreqCount + j) * atomCountInFirstModel + i;
                    Atom atom = atoms[atomIndex];
                    atom.vectorX = xComponents[j];
                    atom.vectorY = yComponents[j];
                    atom.vectorZ = zComponents[j];
                }
            }
            this.discardLines(reader, 12);
            line = reader.readLine();
        }
    }

    void readComponents(String line, int count, float[] components) {
        int i = 0;
        int start = 20;
        while (i < count) {
            components[i] = this.parseFloat(line, start, start + 12);
            ++i;
            start += 12;
        }
    }
}

