/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

class CubeReader
extends AtomSetCollectionReader {
    BufferedReader br;
    String line;
    boolean negativeAtomCount;
    int atomCount;
    final int[] voxelCounts = new int[3];
    final float[] origin = new float[3];
    final float[][] voxelVectors = new float[3][];
    float[][][] voxelData;

    CubeReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader br) throws Exception {
        this.br = br;
        this.atomSetCollection = new AtomSetCollection("cube");
        try {
            this.atomSetCollection.newAtomSet();
            this.readTitleLines();
            this.readAtomCountAndOrigin();
            this.readVoxelVectors();
            this.readAtoms();
        }
        catch (Exception ex) {
            this.atomSetCollection.errorMessage = "Could not read Cube file:" + ex + "\n line:\n" + this.line;
            ex.printStackTrace();
        }
        return this.atomSetCollection;
    }

    void readTitleLines() throws Exception {
        this.line = this.br.readLine().trim() + " - ";
        this.line = this.line + this.br.readLine().trim();
        this.atomSetCollection.setAtomSetName("" + this.line);
    }

    void readAtomCountAndOrigin() throws Exception {
        this.line = this.br.readLine();
        this.atomCount = this.parseInt(this.line);
        this.origin[0] = this.parseFloat(this.line, this.ichNextParse);
        this.origin[1] = this.parseFloat(this.line, this.ichNextParse);
        this.origin[2] = this.parseFloat(this.line, this.ichNextParse);
        if (this.atomCount < 0) {
            this.atomCount = -this.atomCount;
            this.negativeAtomCount = true;
        }
    }

    void readVoxelVectors() throws Exception {
        this.readVoxelVector(0);
        this.readVoxelVector(1);
        this.readVoxelVector(2);
    }

    void readVoxelVector(int voxelVectorIndex) throws Exception {
        this.line = this.br.readLine();
        float[] voxelVector = new float[3];
        this.voxelVectors[voxelVectorIndex] = voxelVector;
        this.voxelCounts[voxelVectorIndex] = this.parseInt(this.line);
        voxelVector[0] = this.parseFloat(this.line, this.ichNextParse);
        voxelVector[1] = this.parseFloat(this.line, this.ichNextParse);
        voxelVector[2] = this.parseFloat(this.line, this.ichNextParse);
    }

    void readAtoms() throws Exception {
        for (int i = 0; i < this.atomCount; ++i) {
            this.line = this.br.readLine();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (byte)this.parseInt(this.line);
            atom.partialCharge = this.parseFloat(this.line, this.ichNextParse);
            atom.x = this.parseFloat(this.line, this.ichNextParse) * 0.5291772f;
            atom.y = this.parseFloat(this.line, this.ichNextParse) * 0.5291772f;
            atom.z = this.parseFloat(this.line, this.ichNextParse) * 0.5291772f;
        }
    }
}

