/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;

class CsfReader
extends AtomSetCollectionReader {
    BufferedReader reader;
    String line;
    int nAtoms = 0;
    static final byte conID = 1;
    static final byte objCls1 = 2;
    static final byte objID1 = 3;
    static final byte objCls2 = 4;
    static final byte objID2 = 5;
    static final byte CONNECTOR_PROPERTY_MAX = 6;
    static final String[] connectorFields = new String[]{"ID", "objCls1", "objID1", "objCls2", "objID2"};
    static final byte[] connectorFieldMap = new byte[]{1, 2, 3, 4, 5};
    Hashtable connectors = new Hashtable();
    static final byte NONE = 0;
    static final byte atomID = 1;
    static final byte sym = 2;
    static final byte anum = 3;
    static final byte chrg = 4;
    static final byte xyz_coordinates = 5;
    static final byte ATOM_PROPERTY_MAX = 6;
    static final String[] atomFields = new String[]{"ID", "sym", "anum", "chrg", "xyz_coordinates"};
    static final byte[] atomFieldMap = new byte[]{1, 2, 3, 4, 5};
    static final byte bondID = 1;
    static final byte bondType = 2;
    static final byte BOND_PROPERTY_MAX = 3;
    static final String[] bondFields;
    static final byte[] bondFieldMap;
    int nBonds = 0;
    static final byte vibID = 1;
    static final byte normalMode = 2;
    static final byte vibEnergy = 3;
    static final byte transitionDipole = 4;
    static final byte lineWidth = 5;
    static final byte VIB_PROPERTY_MAX = 6;
    static final String[] vibFields;
    static final byte[] vibFieldMap;

    CsfReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("csf");
        this.line = reader.readLine();
        while (this.line != null) {
            if (this.line.startsWith("object_class")) {
                this.processObjectClass();
                continue;
            }
            this.line = reader.readLine();
        }
        return this.atomSetCollection;
    }

    private void processObjectClass() throws Exception {
        if (this.line.equals("object_class connector")) {
            this.processConnectorObject();
            return;
        }
        if (this.line.equals("object_class atom")) {
            this.processAtomObject();
            return;
        }
        if (this.line.equals("object_class bond")) {
            this.processBondObject();
            return;
        }
        if (this.line.equals("object_class vibrational_level")) {
            this.processVibrationObject();
            return;
        }
        this.line = this.reader.readLine();
    }

    void skipTo(String startsWith) throws Exception {
        while ((this.line = this.reader.readLine()) != null && this.line.indexOf(startsWith) != 0) {
        }
    }

    int parseLineParameters(String[] fields, byte[] fieldMap, int[] fieldTypes, boolean[] propertyReferenced) throws Exception {
        String[] tokens = this.getTokens(this.line);
        int fieldCount = -1;
        int ipt = tokens.length;
        block0: while (--ipt >= 0) {
            String field = tokens[ipt];
            int i = fields.length;
            while (--i >= 0) {
                if (!field.equals(fields[i])) continue;
                int iproperty = fieldMap[i];
                propertyReferenced[iproperty] = true;
                fieldTypes[ipt] = iproperty;
                if (fieldCount != -1) continue block0;
                fieldCount = ipt + 1;
                continue block0;
            }
        }
        return fieldCount;
    }

    void processConnectorObject() throws Exception {
        int[] fieldTypes = new int[100];
        boolean[] propertyReferenced = new boolean[6];
        this.skipTo("ID");
        int fieldCount = this.parseLineParameters(connectorFields, connectorFieldMap, fieldTypes, propertyReferenced);
        block7: while ((this.line = this.reader.readLine()) != null && !this.line.startsWith("property_flags:")) {
            String thisAtomID = null;
            String thisBondID = null;
            String[] tokens = this.getTokens(this.line);
            block8: for (int i = 0; i < fieldCount; ++i) {
                String field = tokens[i];
                switch (fieldTypes[i]) {
                    case 0: 
                    case 1: {
                        continue block8;
                    }
                    case 2: {
                        if (field.equals("atom")) continue block8;
                        continue block7;
                    }
                    case 4: {
                        if (field.equals("bond")) continue block8;
                        continue block7;
                    }
                    case 3: {
                        thisAtomID = "Atom" + field;
                        continue block8;
                    }
                    case 5: {
                        thisBondID = "Bond" + field;
                        continue block8;
                    }
                }
            }
            if (thisAtomID == null || thisBondID == null) continue;
            if (this.connectors.containsKey(thisBondID)) {
                String[] connect = (String[])this.connectors.get(thisBondID);
                connect[1] = thisAtomID;
                this.connectors.put(thisBondID, connect);
                continue;
            }
            String[] connect = new String[2];
            connect[0] = thisAtomID;
            this.connectors.put(thisBondID, connect);
        }
    }

    void processAtomObject() throws Exception {
        this.nAtoms = 0;
        int[] fieldTypes = new int[100];
        boolean[] atomPropertyReferenced = new boolean[6];
        this.skipTo("ID");
        int fieldCount = this.parseLineParameters(atomFields, atomFieldMap, fieldTypes, atomPropertyReferenced);
        while ((this.line = this.reader.readLine()) != null && !this.line.startsWith("property_flags:")) {
            String[] tokens = this.getTokens(this.line);
            Atom atom = new Atom();
            block8: for (int i = 0; i < fieldCount; ++i) {
                String field = tokens[i];
                if (field == null) {
                    this.logger.log("field == null in " + this.line);
                }
                switch (fieldTypes[i]) {
                    case 0: {
                        continue block8;
                    }
                    case 1: {
                        atom.atomName = "Atom" + field;
                        continue block8;
                    }
                    case 2: {
                        atom.elementSymbol = field;
                        continue block8;
                    }
                    case 3: {
                        continue block8;
                    }
                    case 5: {
                        atom.x = this.parseFloat(field);
                        field = tokens[i + 1];
                        atom.y = this.parseFloat(field);
                        field = tokens[i + 2];
                        atom.z = this.parseFloat(field);
                    }
                }
            }
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                this.logger.log("atom " + atom.atomName + " has invalid/unknown coordinates");
                continue;
            }
            ++this.nAtoms;
            this.atomSetCollection.addAtomWithMappedName(atom);
        }
    }

    void processBondObject() throws Exception {
        int[] fieldTypes = new int[100];
        boolean[] propertyReferenced = new boolean[3];
        this.skipTo("ID");
        int fieldCount = this.parseLineParameters(bondFields, bondFieldMap, fieldTypes, propertyReferenced);
        while ((this.line = this.reader.readLine()) != null && !this.line.startsWith("property_flags:")) {
            String thisBondID = null;
            String[] tokens = this.getTokens(this.line);
            block6: for (int i = 0; i < fieldCount; ++i) {
                String field = tokens[i];
                switch (fieldTypes[i]) {
                    case 0: {
                        continue block6;
                    }
                    case 1: {
                        thisBondID = "Bond" + field;
                        continue block6;
                    }
                    case 2: {
                        int order = 1;
                        if (field.equals("single")) {
                            order = 1;
                        } else if (field.equals("double")) {
                            order = 2;
                        } else if (field.equals("triple")) {
                            order = 3;
                        } else {
                            this.logger.log("unknown CSF bond order: " + field);
                        }
                        String[] connect = (String[])this.connectors.get(thisBondID);
                        Bond bond = new Bond();
                        bond.atomIndex1 = this.atomSetCollection.getAtomNameIndex(connect[0]);
                        bond.atomIndex2 = this.atomSetCollection.getAtomNameIndex(connect[1]);
                        bond.order = order;
                        this.atomSetCollection.addBond(bond);
                        ++this.nBonds;
                    }
                }
            }
        }
    }

    void processVibrationObject() throws Exception {
        int[] fieldTypes = new int[100];
        boolean[] propertyReferenced = new boolean[6];
        this.skipTo("ID normalMode");
        int thisvibID = -1;
        float[] vibXYZ = new float[3];
        int iatom = this.atomSetCollection.getFirstAtomSetAtomCount();
        int xyzpt = 0;
        Atom[] atoms = this.atomSetCollection.atoms;
        while ((this.line = this.reader.readLine()) != null && !this.line.startsWith("property_flags:")) {
            String[] tokens = this.getTokens(this.line);
            if (this.parseInt(tokens[0]) != thisvibID) {
                thisvibID = this.parseInt(tokens[0]);
                this.atomSetCollection.cloneFirstAtomSetWithBonds(this.nBonds);
            }
            for (int i = 1; i < tokens.length; ++i) {
                vibXYZ[xyzpt++] = this.parseFloat(tokens[i]);
                if (xyzpt != 3) continue;
                atoms[iatom].addVibrationVector(vibXYZ[0], vibXYZ[1], vibXYZ[2]);
                ++iatom;
                xyzpt = 0;
            }
        }
        this.skipTo("ID");
        int fieldCount = this.parseLineParameters(vibFields, vibFieldMap, fieldTypes, propertyReferenced);
        while ((this.line = this.reader.readLine()) != null && !this.line.startsWith("property_flags:")) {
            String[] tokens = this.getTokens(this.line);
            int thisvib = -1;
            block8: for (int i = 0; i < fieldCount; ++i) {
                String field = tokens[i];
                switch (fieldTypes[i]) {
                    case 0: {
                        continue block8;
                    }
                    case 1: {
                        thisvib = this.parseInt(field);
                        continue block8;
                    }
                    case 3: {
                        this.atomSetCollection.setAtomSetName(field + " cm^-1", thisvib);
                        this.atomSetCollection.setAtomSetProperty(".PATH", "Frequencies");
                    }
                }
            }
        }
    }

    static {
        if (atomFieldMap.length != atomFields.length) {
            CsfReader.atomFields[100] = "explode";
        }
        bondFields = new String[]{"ID", "type"};
        bondFieldMap = new byte[]{1, 2};
        vibFields = new String[]{"ID", "normalMode", "Energy", "transitionDipole"};
        vibFieldMap = new byte[]{1, 2, 3, 4};
    }
}

