/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import netscape.javascript.JSObject;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.CifReader;
import org.jmol.util.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class CmlReader
extends AtomSetCollectionReader {
    Atom atom;
    float[] notionalUnitcell;
    int atomCount;
    Atom[] atomArray = new Atom[100];
    int bondCount;
    Bond[] bondArray = new Bond[100];
    int tokenCount;
    String[] tokens = new String[16];
    int elementContext;
    static final int UNSET = 0;
    static final int CRYSTAL = 1;
    static final int ATOM = 2;
    boolean coordinatesAreFractional;
    boolean keepChars;
    String chars;
    String dictRef;
    String title;
    int moleculeNesting = 0;

    CmlReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        return this.readAtomSetCollectionSax(reader, new CmlHandler(), "cml");
    }

    AtomSetCollection readAtomSetCollectionSax(BufferedReader reader, Object handler, String name) throws Exception {
        this.atomSetCollection = new AtomSetCollection(name);
        XMLReader xmlr = this.getXmlReader();
        if (xmlr == null) {
            this.atomSetCollection.errorMessage = "No XML reader found";
            return this.atomSetCollection;
        }
        InputSource is = new InputSource(reader);
        is.setSystemId("foo");
        xmlr.setFeature("http://xml.org/sax/features/validation", false);
        xmlr.setFeature("http://xml.org/sax/features/namespaces", true);
        xmlr.setEntityResolver((CmlHandler)handler);
        xmlr.setContentHandler((CmlHandler)handler);
        xmlr.setErrorHandler((CmlHandler)handler);
        xmlr.parse(is);
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    AtomSetCollection readAtomSetCollectionFromDOM(Object Node2) throws Exception {
        JSObject DOMNode = (JSObject)Node2;
        this.atomSetCollection = new AtomSetCollection("cml");
        this.checkFirstNode(DOMNode);
        this.walkDOMTree(DOMNode);
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    XMLReader getXmlReader() {
        XMLReader xmlr = null;
        if (xmlr == null && System.getProperty("java.version").compareTo("1.4") >= 0) {
            xmlr = this.allocateXmlReader14();
        }
        if (xmlr == null) {
            xmlr = this.allocateXmlReaderAelfred2();
        }
        return xmlr;
    }

    XMLReader allocateXmlReader14() {
        XMLReader xmlr = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            xmlr = saxParser.getXMLReader();
            Logger.debug("Using JAXP/SAX XML parser.");
        }
        catch (Exception e) {
            Logger.error("Could not instantiate JAXP/SAX XML reader: " + e.getMessage());
        }
        return xmlr;
    }

    XMLReader allocateXmlReaderAelfred2() {
        XMLReader xmlr = null;
        try {
            xmlr = (XMLReader)this.getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
            Logger.debug("Using Aelfred2 XML parser.");
        }
        catch (Exception e) {
            Logger.error("Could not instantiate Aelfred2 XML reader!");
        }
        return xmlr;
    }

    void breakOutTokens(String str) {
        StringTokenizer st = new StringTokenizer(str);
        this.tokenCount = st.countTokens();
        if (this.tokenCount > this.tokens.length) {
            this.tokens = new String[this.tokenCount];
        }
        for (int i = 0; i < this.tokenCount; ++i) {
            try {
                this.tokens[i] = st.nextToken();
                continue;
            }
            catch (NoSuchElementException nsee) {
                this.tokens[i] = null;
            }
        }
    }

    int parseBondToken(String str) {
        if (str.length() == 1) {
            switch (str.charAt(0)) {
                case 'S': {
                    return 1;
                }
                case 'D': {
                    return 2;
                }
                case 'T': {
                    return 3;
                }
                case 'A': {
                    return 4;
                }
            }
            return this.parseInt(str);
        }
        float floatOrder = this.parseFloat(str);
        if ((double)floatOrder == 1.5) {
            return 4;
        }
        if (floatOrder == 2.0f) {
            return 2;
        }
        if (floatOrder == 3.0f) {
            return 3;
        }
        return 1;
    }

    void breakOutAtomTokens(String str) {
        this.breakOutTokens(str);
        this.checkAtomArrayLength(this.tokenCount);
    }

    void checkAtomArrayLength(int newAtomCount) {
        if (this.atomCount == 0) {
            if (newAtomCount > this.atomArray.length) {
                this.atomArray = new Atom[newAtomCount];
            }
            int i = newAtomCount;
            while (--i >= 0) {
                this.atomArray[i] = new Atom();
            }
            this.atomCount = newAtomCount;
        } else if (newAtomCount != this.atomCount) {
            throw new IndexOutOfBoundsException("bad atom attribute length");
        }
    }

    void breakOutBondTokens(String str) {
        this.breakOutTokens(str);
        this.checkBondArrayLength(this.tokenCount);
    }

    void checkBondArrayLength(int newBondCount) {
        if (this.bondCount == 0) {
            if (newBondCount > this.bondArray.length) {
                this.bondArray = new Bond[newBondCount];
            }
            int i = newBondCount;
            while (--i >= 0) {
                this.bondArray[i] = new Bond();
            }
            this.bondCount = newBondCount;
        } else if (newBondCount != this.bondCount) {
            throw new IndexOutOfBoundsException("bad bond attribute length");
        }
    }

    void checkFirstNode(JSObject DOMNode) {
        if (DOMNode == null) {
            throw new RuntimeException("Not a node");
        }
        String namespaceURI = (String)DOMNode.getMember("namespaceURI");
        String localName = (String)DOMNode.getMember("localName");
        if ("http://www.xml-cml.org/schema/cml2/core" != namespaceURI || "cml" != localName) {
            new RuntimeException("Not a cml:cml node");
        }
    }

    void walkDOMTree(JSObject DOMNode) {
        String namespaceURI = (String)DOMNode.getMember("namespaceURI");
        String localName = (String)DOMNode.getMember("localName");
        String qName = (String)DOMNode.getMember("nodeName");
        JSObject attributes = (JSObject)DOMNode.getMember("attributes");
        HashMap atts = attributes != null ? this.attributesToHashMap(attributes) : new HashMap(0);
        this.processStartElement(namespaceURI, localName, qName, atts);
        if (((Boolean)DOMNode.call("hasChildNodes", null)).booleanValue()) {
            for (JSObject nextNode = (JSObject)DOMNode.getMember("firstChild"); nextNode != (JSObject)null; nextNode = (JSObject)nextNode.getMember("nextSibling")) {
                this.walkDOMTree(nextNode);
            }
        }
        this.processEndElement(namespaceURI, localName, qName);
    }

    HashMap attributesToHashMap(JSObject attributes) {
        Object[] interestingAtts = new Object[]{"title", "id", "x3", "y3", "z3", "x2", "y2", "elementType", "formalCharge", "atomId", "atomRefs2", "order", "atomRef1", "atomRef2", "dictRef"};
        int numAtts = ((Number)attributes.getMember("length")).intValue();
        HashMap<String, String> atts = new HashMap<String, String>(numAtts);
        int i = interestingAtts.length;
        while (--i >= 0) {
            Object[] attArgs = new Object[]{interestingAtts[i]};
            JSObject attNode = (JSObject)attributes.call("getNamedItem", attArgs);
            if (attNode == null) continue;
            String attLocalName = (String)attNode.getMember("name");
            String attValue = (String)attNode.getMember("value");
            atts.put(attLocalName, attValue);
        }
        return atts;
    }

    void processStartElement(String namespaceURI, String localName, String qName, HashMap atts) {
        if ("molecule".equals(localName)) {
            if (++this.moleculeNesting > 1) {
                return;
            }
            this.atomSetCollection.newAtomSet();
            String collectionName = null;
            if (atts.containsKey("title")) {
                collectionName = (String)atts.get("title");
            } else if (atts.containsKey("id")) {
                collectionName = (String)atts.get("id");
            }
            if (collectionName != null) {
                this.atomSetCollection.setAtomSetName(collectionName);
            }
            return;
        }
        if ("atom".equals(localName)) {
            this.elementContext = 2;
            this.atom = new Atom();
            boolean coords3D = false;
            this.atom.atomName = (String)atts.get("id");
            if (atts.containsKey("x3")) {
                coords3D = true;
                this.atom.x = this.parseFloat((String)atts.get("x3"));
                this.atom.y = this.parseFloat((String)atts.get("y3"));
                this.atom.z = this.parseFloat((String)atts.get("z3"));
            }
            if (atts.containsKey("x2") && Float.isNaN(this.atom.x)) {
                this.atom.x = this.parseFloat((String)atts.get("x2"));
            }
            if (atts.containsKey("y2") && Float.isNaN(this.atom.y)) {
                this.atom.y = this.parseFloat((String)atts.get("y2"));
            }
            if (atts.containsKey("elementType")) {
                this.atom.elementSymbol = (String)atts.get("elementType");
            }
            if (atts.containsKey("formalCharge")) {
                this.atom.formalCharge = this.parseInt((String)atts.get("formalCharge"));
            }
            if (!coords3D) {
                this.atom.z = 0.0f;
            }
            return;
        }
        if ("atomArray".equals(localName)) {
            int i;
            this.atomCount = 0;
            boolean coords3D = false;
            if (atts.containsKey("atomID")) {
                this.breakOutAtomTokens((String)atts.get("atomID"));
                i = this.tokenCount;
                while (--i >= 0) {
                    this.atomArray[i].atomName = this.tokens[i];
                }
            }
            if (atts.containsKey("x3")) {
                coords3D = true;
                this.breakOutAtomTokens((String)atts.get("x3"));
                i = this.tokenCount;
                while (--i >= 0) {
                    this.atomArray[i].x = this.parseFloat(this.tokens[i]);
                }
            }
            if (atts.containsKey("y3")) {
                this.breakOutAtomTokens((String)atts.get("y3"));
                i = this.tokenCount;
                while (--i >= 0) {
                    this.atomArray[i].y = this.parseFloat(this.tokens[i]);
                }
            }
            if (atts.containsKey("z3")) {
                this.breakOutAtomTokens((String)atts.get("z3"));
                i = this.tokenCount;
                while (--i >= 0) {
                    this.atomArray[i].z = this.parseFloat(this.tokens[i]);
                }
            }
            if (atts.containsKey("x2")) {
                this.breakOutAtomTokens((String)atts.get("x2"));
                i = this.tokenCount;
                while (--i >= 0) {
                    this.atomArray[i].x = this.parseFloat(this.tokens[i]);
                }
            }
            if (atts.containsKey("y2")) {
                this.breakOutAtomTokens((String)atts.get("y2"));
                i = this.tokenCount;
                while (--i >= 0) {
                    this.atomArray[i].y = this.parseFloat(this.tokens[i]);
                }
            }
            if (atts.containsKey("elementType")) {
                this.breakOutAtomTokens((String)atts.get("elementType"));
                i = this.tokenCount;
                while (--i >= 0) {
                    this.atomArray[i].elementSymbol = this.tokens[i];
                }
            }
            i = this.atomCount;
            while (--i >= 0) {
                Atom atom = this.atomArray[i];
                if (coords3D) continue;
                atom.z = 0.0f;
            }
            return;
        }
        if ("bond".equals(localName)) {
            int order = -1;
            if (atts.containsKey("atomRefs2")) {
                this.breakOutTokens((String)atts.get("atomRefs2"));
            }
            if (atts.containsKey("order")) {
                order = this.parseBondToken((String)atts.get("order"));
            }
            if (this.tokenCount == 2 && order > 0) {
                this.atomSetCollection.addNewBond(this.tokens[0], this.tokens[1], order);
            }
            return;
        }
        if ("bondArray".equals(localName)) {
            int i;
            this.bondCount = 0;
            if (atts.containsKey("order")) {
                this.breakOutBondTokens((String)atts.get("order"));
                i = this.tokenCount;
                while (--i >= 0) {
                    this.bondArray[i].order = this.parseBondToken(this.tokens[i]);
                }
            }
            if (atts.containsKey("atomRef1")) {
                this.breakOutBondTokens((String)atts.get("atomRef1"));
                i = this.tokenCount;
                while (--i >= 0) {
                    this.bondArray[i].atomIndex1 = this.atomSetCollection.getAtomNameIndex(this.tokens[i]);
                }
            }
            if (atts.containsKey("atomRef2")) {
                this.breakOutBondTokens((String)atts.get("atomRef2"));
                i = this.tokenCount;
                while (--i >= 0) {
                    this.bondArray[i].atomIndex2 = this.atomSetCollection.getAtomNameIndex(this.tokens[i]);
                }
            }
            return;
        }
        if ("crystal".equals(localName)) {
            this.elementContext = 1;
            this.notionalUnitcell = new float[6];
            int i = 6;
            while (--i >= 0) {
                this.notionalUnitcell[i] = Float.NaN;
            }
            return;
        }
        if ("scalar".equals(localName)) {
            this.title = (String)atts.get("title");
            this.dictRef = (String)atts.get("dictRef");
            this.keepChars = true;
            return;
        }
    }

    void processEndElement(String uri, String localName, String qName) {
        if ("molecule".equals(localName)) {
            --this.moleculeNesting;
            return;
        }
        if ("atom".equals(localName)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            this.elementContext = 0;
            return;
        }
        if ("crystal".equals(localName)) {
            this.elementContext = 0;
            int i = 6;
            while (--i >= 0) {
                if (!Float.isNaN(this.notionalUnitcell[i])) continue;
                Logger.error("incomplete/unrecognized unitcell");
                return;
            }
            this.atomSetCollection.setCoordinatesAreFractional(this.coordinatesAreFractional);
            this.atomSetCollection.setNotionalUnitcell(this.notionalUnitcell, this.logger);
            return;
        }
        if ("scalar".equals(localName)) {
            if (this.elementContext == 1) {
                int i;
                if (this.title != null) {
                    i = 6;
                    while (--i >= 0 && !this.title.equals(AtomSetCollection.notionalUnitcellTags[i])) {
                    }
                    if (i >= 0) {
                        this.notionalUnitcell[i] = this.parseFloat(this.chars);
                    }
                }
                if (this.dictRef != null) {
                    i = 6;
                    while (--i >= 0 && !this.dictRef.equals("cif:" + CifReader.cellParamNames[i])) {
                    }
                    if (i >= 0) {
                        this.notionalUnitcell[i] = this.parseFloat(this.chars);
                    }
                }
                return;
            }
            if (this.elementContext == 2 && "jmol:charge".equals(this.dictRef)) {
                this.atom.partialCharge = this.parseFloat(this.chars);
            }
            return;
        }
        if ("atomArray".equals(localName)) {
            for (int i = 0; i < this.atomCount; ++i) {
                Atom atom = this.atomArray[i];
                if (atom.elementSymbol == null || Float.isNaN(atom.z)) continue;
                this.atomSetCollection.addAtomWithMappedName(atom);
            }
            return;
        }
        if ("bondArray".equals(localName)) {
            for (int i = 0; i < this.bondCount; ++i) {
                this.atomSetCollection.addBond(this.bondArray[i]);
            }
            return;
        }
        this.keepChars = false;
        this.title = null;
        this.dictRef = null;
        this.chars = null;
    }

    class CmlHandler
    extends DefaultHandler
    implements ErrorHandler {
        CmlHandler() {
        }

        public void startDocument() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
            HashMap<String, String> atts = new HashMap<String, String>(attributes.getLength());
            int i = attributes.getLength();
            while (--i >= 0) {
                atts.put(attributes.getLocalName(i), attributes.getValue(i));
            }
            CmlReader.this.processStartElement(namespaceURI, localName, qName, atts);
        }

        public void endElement(String uri, String localName, String qName) {
            CmlReader.this.processEndElement(uri, localName, qName);
            CmlReader.this.keepChars = false;
            CmlReader.this.title = null;
            CmlReader.this.dictRef = null;
            CmlReader.this.chars = null;
        }

        public void characters(char[] ch, int start, int length) {
            if (CmlReader.this.keepChars) {
                CmlReader.this.chars = CmlReader.this.chars == null ? new String(ch, start, length) : CmlReader.this.chars + new String(ch, start, length);
            }
        }

        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) {
            Logger.debug("Not resolving this:");
            Logger.debug("      name: " + name);
            Logger.debug("  systemID: " + systemId);
            Logger.debug("  publicID: " + publicId);
            Logger.debug("   baseURI: " + baseURI);
            return null;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            Logger.debug("Not resolving this:");
            Logger.debug("  publicID: " + publicId);
            Logger.debug("  systemID: " + systemId);
            return null;
        }

        public void error(SAXParseException exception) {
            Logger.error("SAX ERROR:" + exception.getMessage());
        }

        public void fatalError(SAXParseException exception) {
            Logger.error("SAX FATAL:" + exception.getMessage());
        }

        public void warning(SAXParseException exception) {
            Logger.warn("SAX WARNING:" + exception.getMessage());
        }
    }
}

