/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Structure;

class CifReader
extends AtomSetCollectionReader {
    int[] unitCells = new int[3];
    int desiredModelNumber;
    int modelNumber = 0;
    boolean normalize = true;
    boolean iHaveAppliedSymmetry = false;
    BufferedReader reader;
    String line;
    RidiculousFileFormatTokenizer tokenizer = new RidiculousFileFormatTokenizer();
    boolean iHaveUnitCell = false;
    float[] notionalUnitcell;
    String spaceGroup;
    boolean coordinatesAreFractional;
    String thisDataSetName = "";
    String chemicalName = "";
    String thisStructuralFormula = "";
    String thisFormula = "";
    static final String[] cellParamNames = new String[]{"_cell_length_a", "_cell_length_b", "_cell_length_c", "_cell_angle_alpha", "_cell_angle_beta", "_cell_angle_gamma", "_cell.length_a", "_cell.length_b", "_cell.length_c", "_cell.angle_alpha", "_cell.angle_beta", "_cell.angle_gamma"};
    static final byte NONE = 0;
    static final byte TYPE_SYMBOL = 1;
    static final byte LABEL = 2;
    static final byte FRACT_X = 3;
    static final byte FRACT_Y = 4;
    static final byte FRACT_Z = 5;
    static final byte CARTN_X = 6;
    static final byte CARTN_Y = 7;
    static final byte CARTN_Z = 8;
    static final byte OCCUPANCY = 9;
    static final byte B_ISO = 10;
    static final byte COMP_ID = 11;
    static final byte ASYM_ID = 12;
    static final byte SEQ_ID = 13;
    static final byte INS_CODE = 14;
    static final byte ALT_ID = 15;
    static final byte GROUP_PDB = 16;
    static final byte MODEL_NO = 17;
    static final byte DUMMY_ATOM = 18;
    static final byte ATOM_PROPERTY_MAX = 19;
    static final String[] atomFields = new String[]{"_atom_site_type_symbol", "_atom_site_label", "_atom_site_auth_atom_id", "_atom_site_fract_x", "_atom_site_fract_y", "_atom_site_fract_z", "_atom_site.Cartn_x", "_atom_site.Cartn_y", "_atom_site.Cartn_z", "_atom_site_occupancy", "_atom_site.b_iso_or_equiv", "_atom_site.auth_comp_id", "_atom_site.auth_asym_id", "_atom_site.auth_seq_id", "_atom_site.pdbx_PDB_ins_code", "_atom_site.label_alt_id", "_atom_site.group_PDB", "_atom_site.pdbx_PDB_model_num", "_atom_site_calc_flag"};
    static final byte[] atomFieldMap = new byte[]{1, 2, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
    static final byte GEOM_BOND_ATOM_SITE_LABEL_1 = 1;
    static final byte GEOM_BOND_ATOM_SITE_LABEL_2 = 2;
    static final byte GEOM_BOND_SITE_SYMMETRY_2 = 3;
    static final byte GEOM_BOND_PROPERTY_MAX = 4;
    static final String[] geomBondFields;
    static final byte[] geomBondFieldMap;
    static final byte CONF_TYPE_ID = 1;
    static final byte BEG_ASYM_ID = 2;
    static final byte BEG_SEQ_ID = 3;
    static final byte BEG_INS_CODE = 4;
    static final byte END_ASYM_ID = 5;
    static final byte END_SEQ_ID = 6;
    static final byte END_INS_CODE = 7;
    static final byte STRUCT_CONF_PROPERTY_MAX = 8;
    static final String[] structConfFields;
    static final byte[] structConfFieldMap;
    static final byte STRUCT_SHEET_RANGE_PROPERTY_MAX = 8;
    static final String[] structSheetRangeFields;
    static final byte[] structSheetRangeFieldMap;
    static final byte SYMOP_XYZ = 1;
    static final byte SYM_EQUIV_XYZ = 2;
    static final byte SYMMETRY_OPERATIONS_PROPERTY_MAX = 3;
    static final String[] symmetryOperationsFields;
    static final byte[] symmetryOperationsFieldMap;

    CifReader() {
    }

    void initialize() {
        this.desiredModelNumber = -1;
        this.unitCells[2] = 0;
        this.unitCells[1] = 0;
        this.unitCells[0] = 0;
    }

    void initialize(int[] params) {
        this.initialize();
        if (params == null) {
            return;
        }
        int ipt = 0;
        if (params.length == 1 || params.length == 4) {
            this.desiredModelNumber = params[ipt++];
        }
        if (params.length < ipt + 3) {
            return;
        }
        this.unitCells[0] = params[ipt++];
        this.unitCells[1] = params[ipt++];
        this.unitCells[2] = params[ipt++];
    }

    void initializeUnitcell() {
        this.iHaveUnitCell = false;
        this.notionalUnitcell = new float[6];
        int i = 6;
        while (--i >= 0) {
            this.notionalUnitcell[i] = Float.NaN;
        }
        this.spaceGroup = "unspecified";
        this.coordinatesAreFractional = false;
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("cif");
        this.line = reader.readLine();
        this.initializeUnitcell();
        this.modelNumber = 0;
        boolean skipping = false;
        boolean iHaveDesiredModel = false;
        boolean inSemicolonString = false;
        while (this.line != null) {
            if (this.line.startsWith(";")) {
                boolean bl = inSemicolonString = !inSemicolonString;
            }
            if (inSemicolonString) {
                this.line = reader.readLine();
                continue;
            }
            if (this.line.startsWith("loop_")) {
                if (!skipping) {
                    this.processLoopBlock();
                    continue;
                }
            } else if (this.line.startsWith("data_")) {
                if (iHaveDesiredModel) break;
                boolean bl = skipping = ++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0;
                if (!skipping) {
                    this.processDataParameter();
                    this.initializeUnitcell();
                    iHaveDesiredModel = this.desiredModelNumber > 0;
                }
            } else if (this.line.startsWith("_chemical_name")) {
                this.processChemicalInfo(reader, "name");
            } else if (this.line.startsWith("_chemical_formula_structural")) {
                this.processChemicalInfo(reader, "structuralFormula");
            } else if (this.line.startsWith("_chemical_formula_sum")) {
                this.processChemicalInfo(reader, "formula");
            } else if (this.line.startsWith("_cell_") || this.line.startsWith("_cell.")) {
                if (!skipping) {
                    this.processCellParameter();
                }
            } else if ((this.line.startsWith("_symmetry_space_group_name_H-M") || this.line.startsWith("_symmetry.space_group_name_H-M")) && !skipping) {
                this.processSymmetrySpaceGroupNameHM();
            }
            this.line = reader.readLine();
        }
        return this.atomSetCollection;
    }

    static final boolean isMatch(String str1, String str2) {
        int cch = str1.length();
        if (str2.length() != cch) {
            return false;
        }
        int i = cch;
        while (--i >= 0) {
            char ch2;
            char ch1 = str1.charAt(i);
            if (ch1 == (ch2 = str2.charAt(i)) || (ch1 == '_' || ch1 == '.') && (ch2 == '_' || ch2 == '.')) continue;
            if (ch1 <= 'Z' && ch1 >= 'A') {
                ch1 = (char)(ch1 + 32);
            } else if (ch2 <= 'Z' && ch2 >= 'A') {
                ch2 = (char)(ch2 + 32);
            }
            if (ch1 == ch2) continue;
            return false;
        }
        return true;
    }

    void processDataParameter() {
        String string = this.thisDataSetName = this.line.length() < 6 ? "" : this.line.substring(5).trim();
        if (this.thisDataSetName.length() > 0) {
            if (this.atomSetCollection.currentAtomSetIndex >= 0) {
                this.atomSetCollection.newAtomSet();
                this.atomSetCollection.setCollectionName("<collection of " + (this.atomSetCollection.currentAtomSetIndex + 1) + " models>");
            } else {
                this.atomSetCollection.setCollectionName(this.thisDataSetName);
            }
        }
        this.logger.log(this.line);
    }

    void processChemicalInfo(BufferedReader reader, String type) throws Exception {
        this.tokenizer.setString(this.line);
        this.tokenizer.nextToken();
        if (!this.tokenizer.hasMoreTokens()) {
            this.tokenizer.setStringNextLine(reader);
        }
        String info = this.tokenizer.nextToken();
        if (type.equals("name")) {
            this.chemicalName = this.chemicalName + " " + info;
        } else if (type.equals("structuralFormula")) {
            this.thisStructuralFormula = info;
        } else if (type.equals("formula")) {
            this.thisFormula = info;
        }
        this.logger.log(type + " = " + info);
    }

    void processSymmetrySpaceGroupNameHM() {
        this.tokenizer.setString(this.line.substring(30).trim());
        this.spaceGroup = this.tokenizer.nextToken();
    }

    void processCellParameter() {
        String cellParameter = this.parseToken(this.line);
        int i = cellParamNames.length;
        while (--i >= 0) {
            if (!CifReader.isMatch(cellParameter, cellParamNames[i])) continue;
            this.notionalUnitcell[i % 6] = this.parseFloat(this.line, this.ichNextParse);
            this.iHaveUnitCell = true;
            return;
        }
    }

    private void processLoopBlock() throws Exception {
        this.line = this.reader.readLine().trim();
        if (this.line.startsWith("_atom_site_") || this.line.startsWith("_atom_site.")) {
            this.processAtomSiteLoopBlock();
            this.atomSetCollection.setAtomSetName(this.thisDataSetName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("chemicalName", this.chemicalName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("structuralFormula", this.thisStructuralFormula);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("formula", this.thisFormula);
            this.atomSetCollection.setCoordinatesAreFractional(this.coordinatesAreFractional);
            if (this.iHaveUnitCell && this.atomSetCollection.setNotionalUnitcell(this.notionalUnitcell, this.logger)) {
                this.atomSetCollection.setAtomSetSpaceGroup(this.spaceGroup);
                if (this.atomSetCollection.haveSymmetry()) {
                    this.atomSetCollection.applySymmetry(this.normalize, this.unitCells);
                    this.iHaveAppliedSymmetry = true;
                }
            }
            return;
        }
        if (this.line.startsWith("_geom_bond")) {
            if (this.iHaveAppliedSymmetry) {
                this.line = this.reader.readLine();
                return;
            }
            this.processGeomBondLoopBlock();
            return;
        }
        if (this.line.startsWith("_struct_conf") && !this.line.startsWith("_struct_conf_type")) {
            this.processStructConfLoopBlock();
            return;
        }
        if (this.line.startsWith("_struct_sheet_range")) {
            this.processStructSheetRangeLoopBlock();
            return;
        }
        if (this.line.startsWith("_struct_sheet_range")) {
            this.processStructSheetRangeLoopBlock();
            return;
        }
        if (this.line.startsWith("_symmetry_equiv_pos") || this.line.startsWith("space_group_symop")) {
            this.processSymmetryOperationsLoopBlock();
            return;
        }
        this.skipLoopHeaders();
        this.skipLoopData();
    }

    private void skipLoopHeaders() throws Exception {
        while (this.line != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) == '_') {
            this.line = this.reader.readLine();
        }
    }

    private void skipLoopData() throws Exception {
        while (this.line != null) {
            char ch;
            this.line = this.line.trim();
            if (this.line.length() != 0 && ((ch = this.line.charAt(0)) == '_' || ch == '#' || this.line.startsWith("loop_") || this.line.startsWith("data_"))) break;
            this.line = this.reader.readLine();
        }
    }

    void processAtomSiteLoopBlock() throws Exception {
        char chFirst;
        int lineLength;
        int i;
        int currentModelNO = -1;
        boolean isPDB = false;
        int[] fieldTypes = new int[100];
        boolean[] atomPropertyReferenced = new boolean[19];
        int fieldCount = this.parseLoopParameters(atomFields, atomFieldMap, fieldTypes, atomPropertyReferenced);
        if (atomPropertyReferenced[6]) {
            this.coordinatesAreFractional = false;
            for (i = 3; i < 5; ++i) {
                this.disableField(fieldCount, fieldTypes, i);
            }
        } else if (atomPropertyReferenced[3]) {
            this.coordinatesAreFractional = true;
            for (i = 6; i < 8; ++i) {
                this.disableField(fieldCount, fieldTypes, i);
            }
        } else {
            this.skipLoopData();
            return;
        }
        int alternateLocationID = 48;
        while (this.line != null && (lineLength = this.line.length()) != 0 && (chFirst = this.line.charAt(0)) != '#' && chFirst != '_' && !this.line.startsWith("loop_") && !this.line.startsWith("data_")) {
            if (chFirst == ' ') {
                int i2 = lineLength;
                while (--i2 >= 0 && this.line.charAt(i2) == ' ') {
                }
                if (i2 < 0) break;
            }
            this.tokenizer.setString(this.line);
            Atom atom = new Atom();
            block22: for (int i3 = 0; i3 < fieldCount; ++i3) {
                String field;
                if (!this.tokenizer.hasMoreTokens()) {
                    this.tokenizer.setStringNextLine(this.reader);
                }
                if ((field = this.tokenizer.nextToken()) == null) {
                    this.logger.log("field == null!");
                }
                switch (fieldTypes[i3]) {
                    case 0: {
                        continue block22;
                    }
                    case 1: {
                        char ch1;
                        char ch0;
                        String elementSymbol = field.length() < 2 ? field : (Atom.isValidElementSymbol(ch0 = field.charAt(0), ch1 = Character.toLowerCase(field.charAt(1))) ? "" + ch0 + ch1 : "" + ch0);
                        atom.elementSymbol = elementSymbol;
                        continue block22;
                    }
                    case 2: {
                        atom.atomName = field;
                        continue block22;
                    }
                    case 3: 
                    case 6: {
                        atom.x = this.parseFloat(field);
                        continue block22;
                    }
                    case 4: 
                    case 7: {
                        atom.y = this.parseFloat(field);
                        continue block22;
                    }
                    case 5: 
                    case 8: {
                        atom.z = this.parseFloat(field);
                        continue block22;
                    }
                    case 9: {
                        float floatOccupancy = this.parseFloat(field);
                        if (Float.isNaN(floatOccupancy)) continue block22;
                        atom.occupancy = (int)(floatOccupancy * 100.0f);
                        continue block22;
                    }
                    case 10: {
                        atom.bfactor = this.parseFloat(field);
                        continue block22;
                    }
                    case 11: {
                        atom.group3 = field;
                        continue block22;
                    }
                    case 12: {
                        char firstChar;
                        if (field.length() > 1) {
                            this.logger.log("Don't know how to deal with chains more than 1 char", field);
                        }
                        if ((firstChar = field.charAt(0)) == '?' || firstChar == '.') continue block22;
                        atom.chainID = firstChar;
                        continue block22;
                    }
                    case 13: {
                        atom.sequenceNumber = this.parseInt(field);
                        continue block22;
                    }
                    case 14: {
                        char insCode = field.charAt(0);
                        if (insCode == '?' || insCode == '.') continue block22;
                        atom.chainID = insCode;
                        continue block22;
                    }
                    case 15: {
                        alternateLocationID = field.charAt(0);
                        if (alternateLocationID == 63 || alternateLocationID == 46) continue block22;
                        atom.alternateLocationID = (char)alternateLocationID;
                        continue block22;
                    }
                    case 16: {
                        isPDB = true;
                        if (!"HETATM".equals(field)) continue block22;
                        atom.isHetero = true;
                        continue block22;
                    }
                    case 17: {
                        int modelNO = this.parseInt(field);
                        if (modelNO == currentModelNO) continue block22;
                        this.atomSetCollection.newAtomSet();
                        currentModelNO = modelNO;
                        continue block22;
                    }
                    case 18: {
                        if (!"dum".equals(field)) continue block22;
                        atom.x = Float.NaN;
                        continue block22;
                    }
                }
            }
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                this.logger.log("atom " + atom.atomName + " has invalid/unknown coordinates");
            } else {
                this.atomSetCollection.addAtomWithMappedName(atom);
            }
            this.line = this.reader.readLine();
        }
        if (isPDB) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", new Boolean(isPDB));
        }
    }

    void disableField(int fieldCount, int[] fieldTypes, int fieldIndex) {
        int i = fieldCount;
        while (--i >= 0) {
            if (fieldTypes[i] != fieldIndex) continue;
            fieldTypes[i] = 0;
        }
    }

    int parseLoopParameters(String[] fields, byte[] fieldMap, int[] fieldTypes, boolean[] propertyReferenced) throws Exception {
        int fieldCount = 0;
        while (this.line != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) == '_') {
            int i = fields.length;
            while (--i >= 0) {
                if (!CifReader.isMatch(this.line, fields[i])) continue;
                int iproperty = fieldMap[i];
                propertyReferenced[iproperty] = true;
                fieldTypes[fieldCount] = iproperty;
                break;
            }
            ++fieldCount;
            this.line = this.reader.readLine();
        }
        return fieldCount;
    }

    void processGeomBondLoopBlock() throws Exception {
        int[] fieldTypes = new int[100];
        boolean[] propertyReferenced = new boolean[4];
        int fieldCount = this.parseLoopParameters(geomBondFields, geomBondFieldMap, fieldTypes, propertyReferenced);
        int i = 4;
        while (--i > 0) {
            if (propertyReferenced[i]) continue;
            this.logger.log("?que? missing _geom_bond property:" + i);
            this.skipLoopData();
            return;
        }
        while (this.line != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) != '#' && this.line.charAt(0) != '_' && !this.line.startsWith("loop_") && !this.line.startsWith("data_")) {
            this.tokenizer.setString(this.line);
            int atomIndex1 = -1;
            int atomIndex2 = -1;
            String symmetry = null;
            block8: for (int i2 = 0; i2 < fieldCount; ++i2) {
                if (!this.tokenizer.hasMoreTokens()) {
                    this.tokenizer.setStringNextLine(this.reader);
                }
                String field = this.tokenizer.nextToken();
                switch (fieldTypes[i2]) {
                    case 0: {
                        continue block8;
                    }
                    case 1: {
                        atomIndex1 = this.atomSetCollection.getAtomNameIndex(field);
                        continue block8;
                    }
                    case 2: {
                        atomIndex2 = this.atomSetCollection.getAtomNameIndex(field);
                        continue block8;
                    }
                    case 3: {
                        if (field.charAt(0) == '.') continue block8;
                        symmetry = field;
                    }
                }
            }
            if (atomIndex1 >= 0 && atomIndex2 >= 0 && symmetry == null) {
                Bond bond = new Bond();
                bond.atomIndex1 = atomIndex1;
                bond.atomIndex2 = atomIndex2;
                this.atomSetCollection.addBond(bond);
            }
            this.line = this.reader.readLine();
        }
    }

    void processStructConfLoopBlock() throws Exception {
        int[] fieldTypes = new int[100];
        boolean[] propertyReferenced = new boolean[8];
        int fieldCount = this.parseLoopParameters(structConfFields, structConfFieldMap, fieldTypes, propertyReferenced);
        int i = 8;
        while (--i > 0) {
            if (propertyReferenced[i]) continue;
            this.logger.log("?que? missing _struct_conf property:" + i);
            this.skipLoopData();
            return;
        }
        while (this.line != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) != '#') {
            this.tokenizer.setString(this.line);
            Structure structure = new Structure();
            block12: for (int i2 = 0; i2 < fieldCount; ++i2) {
                if (!this.tokenizer.hasMoreTokens()) {
                    this.tokenizer.setStringNextLine(this.reader);
                }
                String field = this.tokenizer.nextToken();
                char firstChar = field.charAt(0);
                switch (fieldTypes[i2]) {
                    case 0: {
                        continue block12;
                    }
                    case 1: {
                        if (field.startsWith("HELX")) {
                            structure.structureType = "helix";
                            continue block12;
                        }
                        if (field.startsWith("TURN")) {
                            structure.structureType = "turn";
                            continue block12;
                        }
                        structure.structureType = "none";
                        continue block12;
                    }
                    case 2: {
                        structure.startChainID = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                        continue block12;
                    }
                    case 3: {
                        structure.startSequenceNumber = this.parseInt(field);
                        continue block12;
                    }
                    case 4: {
                        structure.startInsertionCode = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                        continue block12;
                    }
                    case 5: {
                        structure.endChainID = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                        continue block12;
                    }
                    case 6: {
                        structure.endSequenceNumber = this.parseInt(field);
                        continue block12;
                    }
                    case 7: {
                        structure.endInsertionCode = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
            this.line = this.reader.readLine();
        }
    }

    void processStructSheetRangeLoopBlock() throws Exception {
        int[] fieldTypes = new int[100];
        boolean[] propertyReferenced = new boolean[8];
        int fieldCount = this.parseLoopParameters(structSheetRangeFields, structSheetRangeFieldMap, fieldTypes, propertyReferenced);
        int i = 8;
        while (--i > 1) {
            if (propertyReferenced[i]) continue;
            this.logger.log("?que? missing _struct_conf property:" + i);
            this.skipLoopData();
            return;
        }
        while (this.line != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) != '#') {
            this.tokenizer.setString(this.line);
            Structure structure = new Structure();
            structure.structureType = "sheet";
            block10: for (int i2 = 0; i2 < fieldCount; ++i2) {
                if (!this.tokenizer.hasMoreTokens()) {
                    this.tokenizer.setStringNextLine(this.reader);
                }
                String field = this.tokenizer.nextToken();
                char firstChar = field.charAt(0);
                switch (fieldTypes[i2]) {
                    case 2: {
                        structure.startChainID = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                        continue block10;
                    }
                    case 3: {
                        structure.startSequenceNumber = this.parseInt(field);
                        continue block10;
                    }
                    case 4: {
                        structure.startInsertionCode = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                        continue block10;
                    }
                    case 5: {
                        structure.endChainID = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                        continue block10;
                    }
                    case 6: {
                        structure.endSequenceNumber = this.parseInt(field);
                        continue block10;
                    }
                    case 7: {
                        structure.endInsertionCode = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
            this.line = this.reader.readLine();
        }
    }

    void processSymmetryOperationsLoopBlock() throws Exception {
        char chFirst;
        int lineLength;
        int[] fieldTypes = new int[100];
        boolean[] propertyReferenced = new boolean[3];
        int fieldCount = this.parseLoopParameters(symmetryOperationsFields, symmetryOperationsFieldMap, fieldTypes, propertyReferenced);
        int nRefs = 0;
        int i = 3;
        while (--i > 1) {
            if (!propertyReferenced[i]) continue;
            ++nRefs;
        }
        if (nRefs != 1) {
            this.logger.log("?que? _symmetry_equiv or _space_group_symop property not found");
            this.skipLoopData();
            return;
        }
        while (this.line != null && (lineLength = this.line.length()) != 0 && (chFirst = this.line.charAt(0)) != '#' && chFirst != '_' && !this.line.startsWith("loop_") && !this.line.startsWith("data_")) {
            int i2;
            if (chFirst == ' ') {
                i2 = lineLength;
                while (--i2 >= 0 && this.line.charAt(i2) == ' ') {
                }
                if (i2 < 0) break;
            }
            this.tokenizer.setString(this.line);
            block6: for (i2 = 0; i2 < fieldCount; ++i2) {
                String field;
                if (!this.tokenizer.hasMoreTokens()) {
                    this.tokenizer.setStringNextLine(this.reader);
                }
                if ((field = this.tokenizer.nextToken()) == null) {
                    this.logger.log("field == null!");
                }
                switch (fieldTypes[i2]) {
                    case 1: 
                    case 2: {
                        if (this.atomSetCollection.addSymmetry(field)) continue block6;
                        this.logger.log("Skipping symmetry operation " + field);
                    }
                }
            }
            this.line = this.reader.readLine();
        }
    }

    static {
        if (atomFieldMap.length != atomFields.length) {
            CifReader.atomFields[100] = "explode";
        }
        geomBondFields = new String[]{"_geom_bond_atom_site_label_1", "_geom_bond_atom_site_label_2", "_geom_bond_site_symmetry_2"};
        geomBondFieldMap = new byte[]{1, 2, 3};
        structConfFields = new String[]{"_struct_conf.conf_type_id", "_struct_conf.beg_auth_asym_id", "_struct_conf.beg_auth_seq_id", "_struct_conf.pdbx_beg_PDB_ins_code", "_struct_conf.end_auth_asym_id", "_struct_conf.end_auth_seq_id", "_struct_conf.pdbx_end_PDB_ins_code"};
        structConfFieldMap = new byte[]{1, 2, 3, 4, 5, 6, 7};
        structSheetRangeFields = new String[]{"_struct_sheet_range.beg_auth_asym_id", "_struct_sheet_range.beg_auth_seq_id", "_struct_sheet_range.pdbx_beg_PDB_ins_code", "_struct_sheet_range.end_auth_asym_id", "_struct_sheet_range.end_auth_seq_id", "_struct_sheet_range.pdbx_end_PDB_ins_code"};
        structSheetRangeFieldMap = new byte[]{2, 3, 4, 5, 6, 7};
        symmetryOperationsFields = new String[]{"_space_group_symop_operation_xyz", "_symmetry_equiv_pos_as_xyz"};
        symmetryOperationsFieldMap = new byte[]{1, 2};
    }

    static class RidiculousFileFormatTokenizer {
        String str;
        int ich;
        int cch;

        RidiculousFileFormatTokenizer() {
        }

        void setString(String str) {
            if (str == null) {
                str = "";
            }
            this.str = str;
            this.cch = str.length();
            this.ich = 0;
        }

        void setStringNextLine(BufferedReader reader) throws Exception {
            String str = reader.readLine();
            if (str == null) {
                str = "";
            }
            if (str.length() > 0 && str.charAt(0) == ';') {
                String newline = '\u0001' + str.substring(1);
                str = "";
                while (newline != null) {
                    if (newline.startsWith(";")) {
                        str = str + newline.substring(1) + '\u0001';
                        break;
                    }
                    str = str + newline + "\n";
                    newline = reader.readLine();
                }
            }
            this.setString(str);
        }

        boolean hasMoreTokens() {
            char ch;
            while (this.ich < this.cch && ((ch = this.str.charAt(this.ich)) == ' ' || ch == '\t')) {
                ++this.ich;
            }
            return this.ich < this.cch;
        }

        String nextToken() {
            if (this.ich == this.cch) {
                return null;
            }
            int ichStart = this.ich;
            char ch = this.str.charAt(ichStart);
            if (ch != '\'' && ch != '\"' && ch != '\u0001') {
                while (this.ich < this.cch && (ch = this.str.charAt(this.ich)) != ' ' && ch != '\t') {
                    ++this.ich;
                }
                return this.str.substring(ichStart, this.ich);
            }
            char chOpeningQuote = ch;
            boolean previousCharacterWasQuote = false;
            while (++this.ich < this.cch) {
                ch = this.str.charAt(this.ich);
                if (previousCharacterWasQuote && (ch == ' ' || ch == '\t')) break;
                previousCharacterWasQuote = ch == chOpeningQuote;
            }
            if (this.ich == this.cch) {
                if (previousCharacterWasQuote) {
                    return this.str.substring(ichStart + 1, this.ich - 1);
                }
                return this.str.substring(ichStart, this.ich);
            }
            ++this.ich;
            return this.str.substring(ichStart + 1, this.ich - 2);
        }
    }
}

