/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.adapter.smarter.Structure;
import org.jmol.adapter.smarter.Symmetry;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

class AtomSetCollection {
    String fileTypeName;
    String collectionName;
    Properties atomSetCollectionProperties = new Properties();
    Hashtable atomSetCollectionAuxiliaryInfo = new Hashtable();
    static final String[] globalBooleans = new String[]{"someModelsHaveFractionalCoordinates", "someModelsHaveSymmetry", "someModelsHaveUnitcells"};
    static final int GLOBAL_FRACTCOORD = 0;
    static final int GLOBAL_SYMMETRY = 1;
    static final int GLOBAL_UNITCELLS = 2;
    static final String[] notionalUnitcellTags = new String[]{"a", "b", "c", "alpha", "beta", "gamma"};
    static final String[] dictRefUnitcellTags = new String[]{"cif:_cell_length_a", "cif:_cell_length_b", "cif:cell_length_c", "cif:_cell_length_alpha", "cif:_cell_length_beta", "cif:_cell_length_gamma"};
    int atomCount;
    Atom[] atoms = new Atom[256];
    int bondCount;
    Bond[] bonds = new Bond[256];
    int structureCount;
    Structure[] structures = new Structure[16];
    int atomSetCount;
    int currentAtomSetIndex = -1;
    int[] atomSetNumbers = new int[16];
    String[] atomSetNames = new String[16];
    int[] atomSetAtomCounts = new int[16];
    Properties[] atomSetProperties = new Properties[16];
    Hashtable[] atomSetAuxiliaryInfo = new Hashtable[16];
    String errorMessage;
    float wavelength = Float.NaN;
    boolean coordinatesAreFractional;
    float[] notionalUnitcell = new float[6];
    float[] pdbScaleMatrix;
    float[] pdbScaleTranslate;
    int symmetryCount;
    Symmetry[] symmetries = new Symmetry[4];
    boolean iHaveSymmetry = false;
    int latticeParameter;
    Hashtable atomSymbolicMap = new Hashtable();

    AtomSetCollection(String fileTypeName) {
        this.fileTypeName = fileTypeName;
        ((Hashtable)this.atomSetCollectionProperties).put("PATH_KEY", ".PATH");
        ((Hashtable)this.atomSetCollectionProperties).put("PATH_SEPARATOR", SmarterJmolAdapter.PATH_SEPARATOR);
    }

    AtomSetCollection(AtomSetCollection[] array) {
        this("Array");
        this.setAtomSetCollectionAuxiliaryInfo("isMultiFile", Boolean.TRUE);
        for (int i = 0; i < array.length; ++i) {
            this.appendAtomSetCollection(i, array[i]);
        }
    }

    protected void appendAtomSetCollection(int collectionIndex, AtomSetCollection collection) {
        int existingAtomsCount = this.atomCount;
        int clonedAtoms = 0;
        for (int atomSetNum = 0; atomSetNum < collection.atomSetCount; ++atomSetNum) {
            this.newAtomSet();
            this.setAtomSetName(collection.getAtomSetName(atomSetNum));
            Properties properties = collection.getAtomSetProperties(atomSetNum);
            if (properties != null) {
                Enumeration props = ((Hashtable)properties).keys();
                while (props != null && props.hasMoreElements()) {
                    String key = (String)props.nextElement();
                    this.setAtomSetProperty(key, properties.getProperty(key));
                }
            }
            for (int atomNum = 0; atomNum < collection.atomSetAtomCounts[atomSetNum]; ++atomNum) {
                this.newCloneAtom(collection.atoms[clonedAtoms]);
                ++clonedAtoms;
            }
            this.atomSetAuxiliaryInfo[this.currentAtomSetIndex] = collection.atomSetAuxiliaryInfo[atomSetNum];
            for (int i = 0; i < collection.structureCount; ++i) {
                if (collection.structures[i].modelIndex != atomSetNum && collection.structures[i].modelIndex != -1) continue;
                this.addStructure(collection.structures[i]);
            }
            this.atomSetNames[this.currentAtomSetIndex] = collection.atomSetNames[atomSetNum];
            this.atomSetNumbers[this.currentAtomSetIndex] = (collectionIndex + 1) * 1000 + collection.atomSetNumbers[atomSetNum];
        }
        for (int bondNum = 0; bondNum < collection.bondCount; ++bondNum) {
            Bond bond = collection.bonds[bondNum];
            this.addNewBond(bond.atomIndex1 + existingAtomsCount, bond.atomIndex2 + existingAtomsCount, bond.order);
        }
        int i = globalBooleans.length;
        while (--i >= 0) {
            if ((Boolean)collection.getAtomSetCollectionAuxiliaryInfo(globalBooleans[i]) != Boolean.TRUE) continue;
            this.setGlobalBoolean(i);
        }
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void finish() {
        this.atoms = null;
        this.bonds = null;
        this.pdbScaleTranslate = null;
        this.pdbScaleMatrix = null;
        this.notionalUnitcell = null;
        this.symmetries = null;
    }

    void freeze() {
        this.getAltLocLists();
        this.getInsertionLists();
    }

    void discardPreviousAtoms() {
        int i = this.atomCount;
        while (--i >= 0) {
            this.atoms[i] = null;
        }
        this.atomCount = 0;
        this.atomSymbolicMap.clear();
        this.atomSetCount = 0;
        this.currentAtomSetIndex = -1;
        i = this.atomSetNumbers.length;
        while (--i >= 0) {
            this.atomSetAtomCounts[i] = 0;
            this.atomSetNumbers[i] = 0;
            this.atomSetNames[i] = null;
        }
    }

    Atom newCloneAtom(Atom atom) {
        Atom clone = atom.cloneAtom();
        this.addAtom(clone);
        return clone;
    }

    void cloneFirstAtomSet() {
        this.newAtomSet();
        int firstCount = this.atomSetAtomCounts[0];
        for (int i = 0; i < firstCount; ++i) {
            this.newCloneAtom(this.atoms[i]);
        }
    }

    void cloneFirstAtomSetWithBonds(int nBonds) {
        this.cloneFirstAtomSet();
        int firstCount = this.atomSetAtomCounts[0];
        for (int bondNum = 0; bondNum < nBonds; ++bondNum) {
            Bond bond = this.bonds[this.bondCount - nBonds];
            this.addNewBond(bond.atomIndex1 + firstCount, bond.atomIndex2 + firstCount, bond.order);
        }
    }

    void cloneLastAtomSet() {
        int count = this.getLastAtomSetAtomCount();
        int atomIndex = this.getLastAtomSetAtomIndex();
        this.newAtomSet();
        while (--count >= 0) {
            this.newCloneAtom(this.atoms[atomIndex]);
            ++atomIndex;
        }
    }

    int getFirstAtomSetAtomCount() {
        return this.atomSetAtomCounts[0];
    }

    int getLastAtomSetAtomCount() {
        return this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    int getLastAtomSetAtomIndex() {
        return this.atomCount - this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    Atom addNewAtom() {
        Atom atom = new Atom();
        this.addAtom(atom);
        return atom;
    }

    void addAtom(Atom atom) {
        if (this.atomCount == this.atoms.length) {
            this.atoms = (Atom[])AtomSetCollectionReader.doubleLength(this.atoms);
        }
        this.atoms[this.atomCount++] = atom;
        if (this.atomSetCount == 0) {
            this.atomSetCount = 1;
            this.currentAtomSetIndex = 0;
            this.atomSetNumbers[0] = 1;
        }
        atom.atomSetIndex = this.currentAtomSetIndex;
        int n = this.currentAtomSetIndex;
        this.atomSetAtomCounts[n] = this.atomSetAtomCounts[n] + 1;
    }

    void addAtomWithMappedName(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomName();
    }

    void addAtomWithMappedSerialNumber(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomSerialNumber();
    }

    Bond addNewBond(int atomIndex1, int atomIndex2) {
        return this.addNewBond(atomIndex1, atomIndex2, 1);
    }

    Bond addNewBond(String atomName1, String atomName2) {
        return this.addNewBond(atomName1, atomName2, 1);
    }

    Bond addNewBond(int atomIndex1, int atomIndex2, int order) {
        if (atomIndex1 < 0 || atomIndex1 >= this.atomCount || atomIndex2 < 0 || atomIndex2 >= this.atomCount) {
            return null;
        }
        Bond bond = new Bond(atomIndex1, atomIndex2, order);
        this.addBond(bond);
        return bond;
    }

    Bond addNewBond(String atomName1, String atomName2, int order) {
        return this.addNewBond(this.getAtomNameIndex(atomName1), this.getAtomNameIndex(atomName2), order);
    }

    Bond addNewBondWithMappedSerialNumbers(int atomSerial1, int atomSerial2, int order) {
        return this.addNewBond(this.getAtomSerialNumberIndex(atomSerial1), this.getAtomSerialNumberIndex(atomSerial2), order);
    }

    void addBond(Bond bond) {
        if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0 || bond.order <= 0) {
            Logger.debug(">>>>>>BAD BOND:" + bond.atomIndex1 + "-" + bond.atomIndex2 + ":" + bond.order);
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])AtomSetCollectionReader.setLength(this.bonds, this.bondCount + 1024);
        }
        this.bonds[this.bondCount++] = bond;
    }

    void addStructure(Structure structure) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])AtomSetCollectionReader.setLength(this.structures, this.structureCount + 32);
        }
        structure.modelIndex = this.currentAtomSetIndex;
        this.structures[this.structureCount++] = structure;
    }

    void setAtomSetSpaceGroup(String spaceGroup) {
        this.setAtomSetAuxiliaryInfo("spaceGroup", spaceGroup + "");
    }

    boolean haveSymmetry() {
        return this.currentAtomSetIndex >= 0 && this.iHaveSymmetry;
    }

    void setCoordinatesAreFractional(boolean coordinatesAreFractional) {
        this.coordinatesAreFractional = coordinatesAreFractional;
        this.setAtomSetAuxiliaryInfo("coordinatesAreFractional", new Boolean(coordinatesAreFractional));
        if (coordinatesAreFractional) {
            this.setGlobalBoolean(0);
        }
    }

    boolean setNotionalUnitcell(float[] info, JmolAdapter.Logger logger) {
        this.notionalUnitcell = new float[6];
        logger.log(" checking notionalUnitcell");
        for (int i = 0; i < 6; ++i) {
            if (Float.isNaN(info[i])) {
                logger.log(" missing " + notionalUnitcellTags[i]);
                this.notionalUnitcell = null;
                return false;
            }
            this.notionalUnitcell[i] = info[i];
            logger.log(notionalUnitcellTags[i] + " = " + info[i]);
        }
        this.setAtomSetAuxiliaryInfo("notionalUnitcell", this.notionalUnitcell);
        this.setGlobalBoolean(2);
        return true;
    }

    void setGlobalBoolean(int globalIndex) {
        this.setAtomSetCollectionAuxiliaryInfo(globalBooleans[globalIndex], Boolean.TRUE);
    }

    boolean addSymmetry(String xyz) {
        return this.addSymmetryWithLatt(xyz, Symmetry.ptNoLatt);
    }

    boolean addSymmetryWithLatt(String xyz, int[] ptLatt) {
        Symmetry symmetry = new Symmetry();
        if (!symmetry.setMatrixFromXYZandLatt(xyz, ptLatt)) {
            return false;
        }
        if (this.symmetryCount == this.symmetries.length) {
            this.symmetries = (Symmetry[])AtomSetCollectionReader.setLength(this.symmetries, this.symmetryCount * 2);
        }
        this.symmetries[this.symmetryCount++] = symmetry;
        this.iHaveSymmetry = true;
        return true;
    }

    void setLatticeParameter(int latt) {
        this.latticeParameter = latt;
        Logger.info("Lattice Parameter: " + latt + ": " + Symmetry.getLatticeDesignation(latt));
    }

    void generateLatticeRelatedOperations() {
        int[][] pt = new int[4][4];
        int nOp = Symmetry.getLatticeOperations(this.latticeParameter, pt);
        if (nOp == 0) {
            return;
        }
        int nOpTotal = nOp * (this.latticeParameter > 0 ? 2 : 1) * this.symmetryCount;
        Logger.debug(nOpTotal + " operations total:");
        for (int i = 0; i < nOp; ++i) {
            int nSymm = this.symmetryCount;
            for (int isymm = 0; isymm < nSymm; ++isymm) {
                this.addSymmetryWithLatt(this.symmetries[isymm].xyz, pt[i]);
            }
            if (this.symmetryCount == nOpTotal) break;
        }
    }

    void applySymmetry(boolean normalize) {
        this.applySymmetry(normalize, 0, 0, 0);
    }

    void applySymmetry(boolean normalize, int[] unitCells) {
        this.applySymmetry(normalize, unitCells[0], unitCells[1], unitCells[2]);
    }

    void applySymmetry(boolean normalize, int maxX, int maxY, int maxZ) {
        if (!this.coordinatesAreFractional) {
            return;
        }
        normalize = false;
        int count = this.getLastAtomSetAtomCount();
        int atomIndex = this.getLastAtomSetAtomIndex();
        this.generateLatticeRelatedOperations();
        if (this.symmetryCount > 0 && !normalize) {
            for (int iSym = 0; iSym < this.symmetryCount; ++iSym) {
                this.symmetries[iSym].setOffset(this.atoms, atomIndex, count);
            }
        }
        for (int tx = 0; tx < maxX; ++tx) {
            for (int ty = 0; ty < maxY; ++ty) {
                for (int tz = 0; tz < maxZ; ++tz) {
                    this.symmetryAddAtoms(atomIndex, count, normalize, tx, ty, tz);
                }
            }
        }
        if (this.symmetryCount > 0) {
            String[] symmetryList = new String[this.symmetryCount];
            for (int i = 0; i < this.symmetryCount; ++i) {
                symmetryList[i] = "" + this.symmetries[i].xyz;
            }
            this.setAtomSetAuxiliaryInfo("symmetryOperations", symmetryList);
        }
        this.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", new Integer(atomIndex));
        this.setAtomSetAuxiliaryInfo("presymmetryAtomCount", new Integer(count));
        this.setAtomSetAuxiliaryInfo("symmetryCount", new Integer(this.symmetryCount));
        this.setAtomSetAuxiliaryInfo("latticeDesignation", this.latticeParameter + ":" + Symmetry.getLatticeDesignation(this.latticeParameter));
        this.symmetryCount = 0;
        this.symmetries = new Symmetry[4];
        this.notionalUnitcell = new float[6];
        this.iHaveSymmetry = false;
        this.coordinatesAreFractional = false;
        this.setGlobalBoolean(1);
    }

    void symmetryAddAtoms(int atomIndex, int count, boolean normalize, int transX, int transY, int transZ) {
        for (int iSym = 0; iSym < this.symmetryCount; ++iSym) {
            int i1 = atomIndex;
            int i2 = i1 + count;
            for (int i = i1; i < i2; ++i) {
                Atom atom = new Atom();
                this.symmetries[iSym].newPoint(this.atoms[i], atom, normalize, transX, transY, transZ);
                if (this.atomExistsAtPoint(atom, i1)) continue;
                Atom atom1 = this.newCloneAtom(this.atoms[i]);
                atom1.x = atom.x;
                atom1.y = atom.y;
                atom1.z = atom.z;
            }
        }
    }

    boolean atomExistsAtPoint(Atom atom, int atomFirst) {
        int j = this.atomCount;
        while (--j >= atomFirst) {
            float d = (atom.x - this.atoms[j].x) * (atom.x - this.atoms[j].x) + (atom.y - this.atoms[j].y) * (atom.y - this.atoms[j].y) + (atom.z - this.atoms[j].z) * (atom.z - this.atoms[j].z);
            if (!((double)d < 0.001)) continue;
            return true;
        }
        return false;
    }

    void setCollectionName(String collectionName) {
        if (collectionName != null && (collectionName = collectionName.trim()).length() > 0) {
            this.collectionName = collectionName;
        }
    }

    void mapMostRecentAtomName() {
        if (this.atomCount > 0) {
            int index = this.atomCount - 1;
            String atomName = this.atoms[index].atomName;
            if (atomName != null) {
                this.atomSymbolicMap.put(atomName, new Integer(index));
            }
        }
    }

    void mapMostRecentAtomSerialNumber() {
        if (this.atomCount > 0) {
            int index = this.atomCount - 1;
            int atomSerial = this.atoms[index].atomSerial;
            if (atomSerial != Integer.MIN_VALUE) {
                this.atomSymbolicMap.put(new Integer(atomSerial), new Integer(index));
            }
        }
    }

    void mapAtomName(String atomName, int atomIndex) {
        this.atomSymbolicMap.put(atomName, new Integer(atomIndex));
    }

    int getAtomNameIndex(String atomName) {
        int index = -1;
        Object value = this.atomSymbolicMap.get(atomName);
        if (value != null) {
            index = (Integer)value;
        }
        return index;
    }

    int getAtomSerialNumberIndex(int serialNumber) {
        int index = -1;
        Object value = this.atomSymbolicMap.get(new Integer(serialNumber));
        if (value != null) {
            index = (Integer)value;
        }
        return index;
    }

    void setAtomSetCollectionProperty(String key, String value) {
        ((Hashtable)this.atomSetCollectionProperties).put(key, value);
    }

    String getAtomSetCollectionProperty(String key) {
        return (String)((Hashtable)this.atomSetCollectionProperties).get(key);
    }

    void setAtomSetCollectionAuxiliaryInfo(String key, Object value) {
        this.atomSetCollectionAuxiliaryInfo.put(key, value);
    }

    boolean setAtomSetCollectionPartialCharges(String auxKey) {
        if (!this.atomSetCollectionAuxiliaryInfo.containsKey(auxKey)) {
            return false;
        }
        Vector atomData = (Vector)this.atomSetCollectionAuxiliaryInfo.get(auxKey);
        int i = atomData.size();
        while (--i >= 0) {
            this.atoms[i].partialCharge = ((Float)atomData.get(i)).floatValue();
        }
        return true;
    }

    Object getAtomSetCollectionAuxiliaryInfo(String key) {
        return this.atomSetCollectionAuxiliaryInfo.get(key);
    }

    void newAtomSet() {
        this.currentAtomSetIndex = this.atomSetCount++;
        if (this.atomSetCount > this.atomSetNumbers.length) {
            this.atomSetNumbers = AtomSetCollectionReader.doubleLength(this.atomSetNumbers);
            this.atomSetNames = AtomSetCollectionReader.doubleLength(this.atomSetNames);
            this.atomSetAtomCounts = AtomSetCollectionReader.doubleLength(this.atomSetAtomCounts);
            this.atomSetProperties = (Properties[])AtomSetCollectionReader.doubleLength(this.atomSetProperties);
            this.atomSetAuxiliaryInfo = (Hashtable[])AtomSetCollectionReader.doubleLength(this.atomSetAuxiliaryInfo);
        }
        this.atomSetNumbers[this.currentAtomSetIndex] = this.atomSetCount;
        this.atomSymbolicMap.clear();
    }

    void setAtomSetName(String atomSetName) {
        this.atomSetNames[this.currentAtomSetIndex] = atomSetName;
    }

    void setAtomSetName(String atomSetName, int atomSetIndex) {
        this.atomSetNames[atomSetIndex] = atomSetName;
    }

    void setAtomSetNames(String atomSetName, int n) {
        int idx = this.currentAtomSetIndex;
        while (--n >= 0) {
            this.setAtomSetName(atomSetName, idx);
            --idx;
        }
    }

    void setAtomSetNumber(int atomSetNumber) {
        this.atomSetNumbers[this.currentAtomSetIndex] = atomSetNumber;
    }

    void setAtomSetProperty(String key, String value) {
        this.setAtomSetProperty(key, value, this.currentAtomSetIndex);
    }

    void setAtomSetAuxiliaryInfo(String key, Object value) {
        this.setAtomSetAuxiliaryInfo(key, value, this.currentAtomSetIndex);
    }

    boolean setAtomSetPartialCharges(String auxKey) {
        if (!this.atomSetAuxiliaryInfo[this.currentAtomSetIndex].containsKey(auxKey)) {
            return false;
        }
        Vector atomData = (Vector)this.atomSetAuxiliaryInfo[this.currentAtomSetIndex].get(auxKey);
        int i = atomData.size();
        while (--i >= 0) {
            this.atoms[i].partialCharge = ((Float)atomData.get(i)).floatValue();
        }
        return true;
    }

    void setAtomSetProperty(String key, String value, int atomSetIndex) {
        if (this.atomSetProperties[atomSetIndex] == null) {
            this.atomSetProperties[atomSetIndex] = new Properties();
        }
        ((Hashtable)this.atomSetProperties[atomSetIndex]).put(key, value);
    }

    void setAtomSetAuxiliaryInfo(String key, Object value, int atomSetIndex) {
        if (this.atomSetAuxiliaryInfo[atomSetIndex] == null) {
            this.atomSetAuxiliaryInfo[atomSetIndex] = new Hashtable();
        }
        this.atomSetAuxiliaryInfo[atomSetIndex].put(key, value);
    }

    void setAtomSetProperties(String key, String value, int n) {
        int idx = this.currentAtomSetIndex;
        while (--n >= 0) {
            this.setAtomSetProperty(key, value, idx);
            --idx;
        }
    }

    void cloneLastAtomSetProperties() {
        this.cloneAtomSetProperties(this.currentAtomSetIndex - 1);
    }

    void cloneAtomSetProperties(int index) {
        this.atomSetProperties[this.currentAtomSetIndex] = (Properties)((Hashtable)this.atomSetProperties[index]).clone();
    }

    int getAtomSetNumber(int atomSetIndex) {
        return this.atomSetNumbers[atomSetIndex];
    }

    String getAtomSetName(int atomSetIndex) {
        return this.atomSetNames[atomSetIndex];
    }

    Properties getAtomSetProperties(int atomSetIndex) {
        return this.atomSetProperties[atomSetIndex];
    }

    Hashtable getAtomSetAuxiliaryInfo(int atomSetIndex) {
        return this.atomSetAuxiliaryInfo[atomSetIndex];
    }

    boolean hasAlternateLocations() {
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].alternateLocationID == '\u0000') continue;
            return true;
        }
        return false;
    }

    void getAltLocLists() {
        int i;
        if (!this.hasAlternateLocations()) {
            return;
        }
        String[] lists = new String[this.atomSetCount];
        for (i = 0; i < this.atomSetCount; ++i) {
            lists[i] = "";
        }
        for (i = 0; i < this.atomCount; ++i) {
            char id = this.atoms[i].alternateLocationID;
            if (id == '\u0000' || lists[this.atoms[i].atomSetIndex].indexOf(id) >= 0) continue;
            int n = this.atoms[i].atomSetIndex;
            lists[n] = lists[n] + id;
        }
        for (i = 0; i < this.atomSetCount; ++i) {
            if (lists[i].length() <= 0) continue;
            this.setAtomSetAuxiliaryInfo("altLocs", lists[i], i);
        }
    }

    boolean hasInsertions() {
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].insertionCode == '\u0000') continue;
            return true;
        }
        return false;
    }

    void getInsertionLists() {
        int i;
        if (!this.hasInsertions()) {
            return;
        }
        String[] lists = new String[this.atomSetCount];
        for (i = 0; i < this.atomSetCount; ++i) {
            lists[i] = "";
        }
        for (i = 0; i < this.atomCount; ++i) {
            char id = this.atoms[i].insertionCode;
            if (id == '\u0000' || lists[this.atoms[i].atomSetIndex].indexOf(id) >= 0) continue;
            int n = this.atoms[i].atomSetIndex;
            lists[n] = lists[n] + id;
        }
        for (i = 0; i < this.atomSetCount; ++i) {
            if (lists[i].length() <= 0) continue;
            this.setAtomSetAuxiliaryInfo("insertionCodes", lists[i], i);
        }
    }
}

